/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.commons.sesame.test.sparql;

import info.aduna.iteration.Iteration;
import java.util.List;
import org.apache.marmotta.commons.sesame.test.sparql.SparqlMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.openrdf.query.BindingSet;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.QueryResults;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;

public class SparqlTupleQueryMatcher<T extends RepositoryConnection>
extends SparqlMatcher<T> {
    private final Matcher<Iterable<BindingSet>> matcher;

    protected SparqlTupleQueryMatcher(String baseUri, String query, Matcher<Iterable<BindingSet>> matcher) {
        super(baseUri, query);
        this.matcher = matcher;
    }

    @Override
    protected boolean matchesSPARQL(RepositoryConnection con) throws RepositoryException, QueryEvaluationException, MalformedQueryException {
        TupleQuery tupleQuery = con.prepareTupleQuery(QueryLanguage.SPARQL, this.query, this.baseUri);
        TupleQueryResult result = tupleQuery.evaluate();
        List bindingSets = QueryResults.asList((Iteration)result);
        return this.matcher.matches((Object)bindingSets);
    }

    public void describeTo(Description description) {
        description.appendText(" TupleQuery ").appendValue((Object)this.query).appendText(" to ").appendDescriptionOf(this.matcher);
    }

    public static <T extends RepositoryConnection> Matcher<T> sparqlQuery(String baseUri, String query, Matcher<Iterable<BindingSet>> matcher) {
        return new SparqlTupleQueryMatcher<T>(baseUri, query, matcher);
    }

    @SafeVarargs
    public static <T extends RepositoryConnection> Matcher<T> sparqlQuery(String baseUri, String query, Matcher<Iterable<BindingSet>> ... matchers) {
        return new SparqlTupleQueryMatcher<T>(baseUri, query, (Matcher<Iterable<BindingSet>>)CoreMatchers.allOf(matchers));
    }
}

