/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.commons.sesame.test.sparql;

import org.apache.marmotta.commons.sesame.test.sparql.SparqlMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;

public class SparqlAskMatcher<T extends RepositoryConnection>
extends SparqlMatcher<T> {
    protected SparqlAskMatcher(String baseUri, String query) {
        super(baseUri, query);
    }

    @Override
    protected boolean matchesSPARQL(RepositoryConnection con) throws MalformedQueryException, RepositoryException, QueryEvaluationException {
        BooleanQuery booleanQuery = con.prepareBooleanQuery(QueryLanguage.SPARQL, this.query, this.baseUri);
        return booleanQuery.evaluate();
    }

    public void describeTo(Description description) {
        description.appendText("Query ").appendValue((Object)this.query).appendText(" to match");
    }

    public static <T extends RepositoryConnection> Matcher<T> sparqlAsk(String baseUri, String askQuery) {
        return new SparqlAskMatcher<T>(baseUri, askQuery);
    }

    public static <T extends RepositoryConnection> Matcher<T> sparqlAsk(String askQuery) {
        return SparqlAskMatcher.sparqlAsk(null, askQuery);
    }
}

