/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.commons.sesame.test.connection;

import org.apache.marmotta.commons.sesame.test.base.AbstractRepositoryConnectionMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;

public class HasStatementMatcher<T extends RepositoryConnection>
extends AbstractRepositoryConnectionMatcher<T> {
    private final Resource subject;
    private final URI predicate;
    private final Value object;
    private final Resource[] contexts;

    protected HasStatementMatcher(Resource subject, URI predicate, Value object, Resource ... contexts) {
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
        this.contexts = contexts;
    }

    @Override
    protected boolean matchesConnection(RepositoryConnection con) throws RepositoryException {
        return con.hasStatement(this.subject, this.predicate, this.object, true, this.contexts);
    }

    public void describeTo(Description description) {
        description.appendText("\n to contain Statement(").appendValue((Object)this.subject).appendText(" ").appendValue((Object)this.predicate).appendText(" ").appendValue((Object)this.object).appendText(")");
    }

    public static <T extends RepositoryConnection> Matcher<T> hasStatement(Resource subject, URI predicate, Value object, Resource ... contexts) {
        return new HasStatementMatcher<T>(subject, predicate, object, contexts);
    }
}

