/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.commons.sesame.test.base;

import org.apache.marmotta.commons.sesame.test.base.SesameMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;

public class RepositoryMatcher<T extends Repository>
extends SesameMatcher<T>
implements Matcher<T> {
    private final Matcher<? extends RepositoryConnection> delegate;

    public RepositoryMatcher(Matcher<? extends RepositoryConnection> delegate) {
        this.delegate = delegate;
    }

    protected boolean matchesSafely(Repository repository) {
        boolean bl;
        RepositoryConnection con = repository.getConnection();
        try {
            con.begin();
            boolean matches = this.delegate.matches((Object)con);
            con.commit();
            bl = matches;
        }
        catch (Throwable t) {
            try {
                try {
                    con.rollback();
                    throw t;
                }
                catch (Throwable throwable) {
                    con.close();
                    throw throwable;
                }
            }
            catch (RuntimeException r) {
                throw r;
            }
            catch (Exception e) {
                return false;
            }
        }
        con.close();
        return bl;
    }

    public void describeTo(Description description) {
        this.delegate.describeTo(description);
    }

    protected void describeMismatchSafely(T item, Description mismatchDescription) {
        this.delegate.describeMismatch(item, mismatchDescription);
    }

    public static <T extends Repository> Matcher<T> wrap(Matcher<? extends RepositoryConnection> connectionMatcher) {
        return new RepositoryMatcher<T>(connectionMatcher);
    }
}

