/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldpath.model.transformers;

import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.api.transformers.NodeTransformer;

public class DurationTransformer<Node>
implements NodeTransformer<Duration, Node> {
    private static DatatypeFactory xmlDatatypeFactory;

    private static DatatypeFactory getXmlDataTypeFactory() throws IllegalStateException {
        if (xmlDatatypeFactory == null) {
            try {
                xmlDatatypeFactory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException e) {
                throw new IllegalStateException("Unable to instantiate XML Datatype Factory!", e);
            }
        }
        return xmlDatatypeFactory;
    }

    public Duration transform(RDFBackend<Node> backend, Node node, Map<String, String> configuration) throws IllegalArgumentException {
        if (backend.isLiteral(node)) {
            return DurationTransformer.toDuration(backend.stringValue(node), false);
        }
        throw new IllegalArgumentException("cannot transform node of type " + node.getClass().getCanonicalName() + " to byte");
    }

    private static Duration toDuration(String value, boolean nullAsZeroDuration) throws IllegalArgumentException, IllegalStateException {
        if (value == null) {
            if (nullAsZeroDuration) {
                return DurationTransformer.getXmlDataTypeFactory().newDuration(0L);
            }
            throw new IllegalArgumentException("The parsed value MUST NOT be NULL. Parse \"boolean nullAsZeroDuration=true\" to enable creation of zero lenght durations for NULL values!");
        }
        return DurationTransformer.getXmlDataTypeFactory().newDuration(value);
    }
}

