/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldpath.model.functions.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.api.functions.SelectorFunction;
import org.apache.marmotta.ldpath.model.transformers.StringTransformer;
import org.apache.marmotta.ldpath.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveXmlTagsFunction<Node>
extends SelectorFunction<Node> {
    private static final Logger log = LoggerFactory.getLogger(RemoveXmlTagsFunction.class);
    private final StringTransformer<Node> transformer = new StringTransformer();
    private static Pattern XML_TAG = Pattern.compile("<(\"[^\"]*\"|'[^']*'|[^>])*>", 8);

    public Collection<Node> apply(RDFBackend<Node> rdfBackend, Node context, Collection<Node> ... args) throws IllegalArgumentException {
        if (args.length < 1) {
            log.debug("remove XML tags from context {}", context);
            return java.util.Collections.singleton(rdfBackend.createLiteral(this.doFilter((String)this.transformer.transform((RDFBackend)rdfBackend, (Object)context, (Map)null))));
        }
        log.debug("remove XML tags from parameters");
        Iterator it = Collections.iterator((Collection[])args);
        ArrayList<Object> result = new ArrayList<Object>();
        while (it.hasNext()) {
            result.add(rdfBackend.createLiteral(this.doFilter((String)this.transformer.transform((RDFBackend)rdfBackend, it.next(), (Map)null))));
        }
        return result;
    }

    private String doFilter(String in) {
        return XML_TAG.matcher(in).replaceAll("");
    }

    public String getLocalName() {
        return "removeTags";
    }

    public String getSignature() {
        return "fn:removeTags(content: LiteralList) : LiteralList";
    }

    public String getDescription() {
        return "Function to remove all XML or HTML tags from the content. Can be used in-path, using the current context nodes as argument.";
    }
}

