/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldclient.provider.youtube;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.marmotta.ldclient.api.endpoint.Endpoint;
import org.apache.marmotta.ldclient.api.ldclient.LDClientService;
import org.apache.marmotta.ldclient.api.provider.DataProvider;
import org.apache.marmotta.ldclient.exception.DataRetrievalException;
import org.apache.marmotta.ldclient.model.ClientResponse;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YoutubeVideoPagesProvider
implements DataProvider {
    private static final String YOUTUBE_V = "http://www.youtube.com/v/";
    private static final String YOUTUBE_WATCH = "http://www.youtube.com/watch";
    private static final String YOUTUBE_GDATA = "http://gdata.youtube.com/feeds/api/videos/";
    private static final String FOAF_PRIMARY_TOPIC = "http://xmlns.com/foaf/0.1/primaryTopic";
    private static Logger log = LoggerFactory.getLogger(YoutubeVideoPagesProvider.class);

    public String getName() {
        return "YouTube Page";
    }

    public String[] listMimeTypes() {
        return new String[]{"text/html"};
    }

    public ClientResponse retrieveResource(String resource, LDClientService client, Endpoint endpoint) throws DataRetrievalException {
        URI objUri;
        RepositoryConnection conn;
        SailRepository triples = new SailRepository((Sail)new MemoryStore());
        try {
            triples.initialize();
            conn = triples.getConnection();
        }
        catch (RepositoryException e) {
            String msg = "Error initializing in-memory repository connection: " + e.getMessage();
            log.error(msg);
            throw new RuntimeException(msg, e);
        }
        String uri = resource;
        try {
            objUri = new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("URI '" + uri + "'could not be parsed, it is not a valid URI");
        }
        String video_id = null;
        if (uri.startsWith(YOUTUBE_V)) {
            String[] p_components = objUri.getPath().split("/");
            video_id = p_components[p_components.length - 1];
        } else if (resource.startsWith(YOUTUBE_WATCH)) {
            List params = URLEncodedUtils.parse((URI)objUri, (String)"UTF-8");
            for (NameValuePair pair : params) {
                if (!"v".equals(pair.getName())) continue;
                video_id = pair.getValue();
                break;
            }
        } else if (uri.startsWith(YOUTUBE_GDATA)) {
            video_id = StringUtils.removeStart((String)uri, (String)YOUTUBE_GDATA);
        }
        if (StringUtils.isBlank(video_id)) {
            String msg = "Not valid video id found in '" + uri + "'";
            log.error(msg);
            throw new DataRetrievalException(msg);
        }
        try {
            conn.add((Resource)new URIImpl(uri), (org.openrdf.model.URI)new URIImpl(FOAF_PRIMARY_TOPIC), (Value)new URIImpl("http://youtu.be/" + video_id), new Resource[]{null});
            conn.close();
        }
        catch (RepositoryException e) {
            String msg = "Error adding triples: " + e.getMessage();
            log.error(msg);
            throw new RuntimeException(msg, e);
        }
        ClientResponse clientResponse = new ClientResponse(200, (Repository)triples);
        clientResponse.setExpires(DateUtils.addYears((Date)new Date(), (int)10));
        return clientResponse;
    }
}

