/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.kiwi.hazelcast.caching;

import com.hazelcast.config.Config;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MaxSizeConfig;
import com.hazelcast.config.SerializerConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.nio.serialization.Serializer;
import java.util.Map;
import org.apache.marmotta.kiwi.caching.CacheManager;
import org.apache.marmotta.kiwi.config.CacheMode;
import org.apache.marmotta.kiwi.config.KiWiConfiguration;
import org.apache.marmotta.kiwi.hazelcast.serializer.BNodeSerializer;
import org.apache.marmotta.kiwi.hazelcast.serializer.BooleanLiteralSerializer;
import org.apache.marmotta.kiwi.hazelcast.serializer.DateLiteralSerializer;
import org.apache.marmotta.kiwi.hazelcast.serializer.DoubleLiteralSerializer;
import org.apache.marmotta.kiwi.hazelcast.serializer.IntLiteralSerializer;
import org.apache.marmotta.kiwi.hazelcast.serializer.StringLiteralSerializer;
import org.apache.marmotta.kiwi.hazelcast.serializer.TripleSerializer;
import org.apache.marmotta.kiwi.hazelcast.serializer.UriSerializer;
import org.apache.marmotta.kiwi.hazelcast.util.AsyncMap;
import org.apache.marmotta.kiwi.model.rdf.KiWiAnonResource;
import org.apache.marmotta.kiwi.model.rdf.KiWiBooleanLiteral;
import org.apache.marmotta.kiwi.model.rdf.KiWiDateLiteral;
import org.apache.marmotta.kiwi.model.rdf.KiWiDoubleLiteral;
import org.apache.marmotta.kiwi.model.rdf.KiWiIntLiteral;
import org.apache.marmotta.kiwi.model.rdf.KiWiLiteral;
import org.apache.marmotta.kiwi.model.rdf.KiWiNamespace;
import org.apache.marmotta.kiwi.model.rdf.KiWiNode;
import org.apache.marmotta.kiwi.model.rdf.KiWiStringLiteral;
import org.apache.marmotta.kiwi.model.rdf.KiWiTriple;
import org.apache.marmotta.kiwi.model.rdf.KiWiUriResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastCacheManager
implements CacheManager {
    private static Logger log = LoggerFactory.getLogger(HazelcastCacheManager.class);
    private KiWiConfiguration configuration;
    private Config hcConfiguration;
    private HazelcastInstance hazelcast;
    private AsyncMap<Long, KiWiNode> nodeCache;
    private AsyncMap<Long, KiWiTriple> tripleCache;
    private AsyncMap<String, KiWiUriResource> uriCache;
    private AsyncMap<String, KiWiAnonResource> bnodeCache;
    private AsyncMap<String, KiWiLiteral> literalCache;
    private AsyncMap<String, KiWiNamespace> nsPrefixCache;
    private AsyncMap<String, KiWiNamespace> nsUriCache;
    private Map<Long, Long> registryCache;

    public HazelcastCacheManager(KiWiConfiguration configuration) {
        this.configuration = configuration;
        this.hcConfiguration = new Config();
        if (configuration.isClustered()) {
            this.hcConfiguration.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(true);
            this.hcConfiguration.getNetworkConfig().getJoin().getMulticastConfig().setMulticastPort(configuration.getClusterPort());
            this.hcConfiguration.getNetworkConfig().getJoin().getMulticastConfig().setMulticastGroup(configuration.getClusterAddress());
        } else {
            this.hcConfiguration.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(false);
        }
        this.hcConfiguration.getGroupConfig().setName(configuration.getClusterName());
        this.hcConfiguration.setClassLoader(HazelcastCacheManager.class.getClassLoader());
        this.hcConfiguration.setProperty("hazelcast.logging.type", "slf4j");
        this.setupSerializers();
        this.setupCaches();
        this.hazelcast = Hazelcast.newHazelcastInstance((Config)this.hcConfiguration);
        if (!configuration.isClustered()) {
            log.info("initialised Hazelcast local cache manager");
        } else {
            log.info("initialised Hazelcast distributed cache manager (cluster name: {})", (Object)configuration.getClusterName());
            if (configuration.getCacheMode() != CacheMode.DISTRIBUTED) {
                log.warn("Hazelcast only supports distributed cache mode (mode configuration was {})", (Object)configuration.getCacheMode());
            }
        }
    }

    private void setupSerializers() {
        SerializerConfig scBNode = new SerializerConfig().setImplementation((Serializer)new BNodeSerializer()).setTypeClass(KiWiAnonResource.class);
        this.hcConfiguration.getSerializationConfig().addSerializerConfig(scBNode);
        SerializerConfig scBoolean = new SerializerConfig().setImplementation((Serializer)new BooleanLiteralSerializer()).setTypeClass(KiWiBooleanLiteral.class);
        this.hcConfiguration.getSerializationConfig().addSerializerConfig(scBoolean);
        SerializerConfig scDate = new SerializerConfig().setImplementation((Serializer)new DateLiteralSerializer()).setTypeClass(KiWiDateLiteral.class);
        this.hcConfiguration.getSerializationConfig().addSerializerConfig(scDate);
        SerializerConfig scDouble = new SerializerConfig().setImplementation((Serializer)new DoubleLiteralSerializer()).setTypeClass(KiWiDoubleLiteral.class);
        this.hcConfiguration.getSerializationConfig().addSerializerConfig(scDouble);
        SerializerConfig scInt = new SerializerConfig().setImplementation((Serializer)new IntLiteralSerializer()).setTypeClass(KiWiIntLiteral.class);
        this.hcConfiguration.getSerializationConfig().addSerializerConfig(scInt);
        SerializerConfig scString = new SerializerConfig().setImplementation((Serializer)new StringLiteralSerializer()).setTypeClass(KiWiStringLiteral.class);
        this.hcConfiguration.getSerializationConfig().addSerializerConfig(scString);
        SerializerConfig scTriple = new SerializerConfig().setImplementation((Serializer)new TripleSerializer()).setTypeClass(KiWiTriple.class);
        this.hcConfiguration.getSerializationConfig().addSerializerConfig(scTriple);
        SerializerConfig scUri = new SerializerConfig().setImplementation((Serializer)new UriSerializer()).setTypeClass(KiWiUriResource.class);
        this.hcConfiguration.getSerializationConfig().addSerializerConfig(scUri);
    }

    private void setupCaches() {
        this.setupMapConfig("node-cache", this.configuration.getNodeCacheSize());
        this.setupMapConfig("triple-cache", this.configuration.getTripleCacheSize());
        this.setupMapConfig("uri-cache", this.configuration.getUriCacheSize());
        this.setupMapConfig("bnode-cache", this.configuration.getBNodeCacheSize());
        this.setupMapConfig("literal-cache", this.configuration.getLiteralCacheSize());
        this.setupMapConfig("namespace-prefix-cache", this.configuration.getNamespaceCacheSize());
        this.setupMapConfig("namespace-uri-cache", this.configuration.getNamespaceCacheSize());
    }

    private void setupMapConfig(String name, int size) {
        MapConfig cfg = new MapConfig("node-cache");
        cfg.setMaxSizeConfig(new MaxSizeConfig(size, MaxSizeConfig.MaxSizePolicy.PER_PARTITION));
        cfg.setAsyncBackupCount(1);
        cfg.setBackupCount(0);
        cfg.setEvictionPolicy(MapConfig.EvictionPolicy.LRU);
        cfg.setMaxIdleSeconds(600);
        cfg.setTimeToLiveSeconds(3600);
        this.hcConfiguration.addMapConfig(cfg);
    }

    public Map<Long, KiWiNode> getNodeCache() {
        if (this.nodeCache == null) {
            this.nodeCache = new AsyncMap(this.hazelcast.getMap("node-cache"));
        }
        return this.nodeCache;
    }

    public Map<Long, KiWiTriple> getTripleCache() {
        if (this.tripleCache == null) {
            this.tripleCache = new AsyncMap(this.hazelcast.getMap("triple-cache"));
        }
        return this.tripleCache;
    }

    public Map<String, KiWiUriResource> getUriCache() {
        if (this.uriCache == null) {
            this.uriCache = new AsyncMap(this.hazelcast.getMap("uri-cache"));
        }
        return this.uriCache;
    }

    public Map<String, KiWiAnonResource> getBNodeCache() {
        if (this.bnodeCache == null) {
            this.bnodeCache = new AsyncMap(this.hazelcast.getMap("bnode-cache"));
        }
        return this.bnodeCache;
    }

    public Map<String, KiWiLiteral> getLiteralCache() {
        if (this.literalCache == null) {
            this.literalCache = new AsyncMap(this.hazelcast.getMap("literal-cache"));
        }
        return this.literalCache;
    }

    public Map<String, KiWiNamespace> getNamespaceUriCache() {
        if (this.nsUriCache == null) {
            this.nsUriCache = new AsyncMap(this.hazelcast.getMap("namespace-uri-cache"));
        }
        return this.nsUriCache;
    }

    public Map<String, KiWiNamespace> getNamespacePrefixCache() {
        if (this.nsPrefixCache == null) {
            this.nsPrefixCache = new AsyncMap(this.hazelcast.getMap("namespace-prefix-cache"));
        }
        return this.nsPrefixCache;
    }

    public Map<Long, Long> getRegistryCache() {
        if (this.registryCache == null) {
            this.registryCache = this.hazelcast.getMap("registry-cache");
        }
        return this.registryCache;
    }

    public Map getCacheByName(String name) {
        return this.hazelcast.getMap(name);
    }

    public HazelcastInstance getBackend() {
        return this.hazelcast;
    }

    public void clear() {
        for (Map m : new Map[]{this.nodeCache, this.tripleCache, this.uriCache, this.bnodeCache, this.literalCache, this.nsPrefixCache, this.nsUriCache, this.registryCache}) {
            if (m == null) continue;
            m.clear();
        }
    }

    public void shutdown() {
        this.hazelcast.shutdown();
    }
}

