/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.CapacitySchedulerConf;
import org.apache.hadoop.mapred.CapacityTaskScheduler;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobQueueJobInProgressListener;
import org.apache.hadoop.mapreduce.ID;
import org.apache.hadoop.mapreduce.TaskType;

class CapacitySchedulerQueue {
    static final Log LOG = LogFactory.getLog(CapacityTaskScheduler.class);
    final String queueName;
    volatile float capacityPercent = 0.0f;
    volatile float maxCapacityPercent = -1.0f;
    Map<String, Integer> numJobsByUser = new HashMap<String, Integer>();
    volatile int ulMin;
    volatile float ulMinFactor;
    SlotsUsage mapSlots;
    SlotsUsage reduceSlots;
    final boolean supportsPriorities;
    Map<JobQueueJobInProgressListener.JobSchedulingInfo, JobInProgress> waitingJobs;
    Map<JobQueueJobInProgressListener.JobSchedulingInfo, JobInProgress> initializingJobs;
    Map<JobQueueJobInProgressListener.JobSchedulingInfo, JobInProgress> runningJobs;
    int activeTasks = 0;
    Map<String, UserInfo> users = new HashMap<String, UserInfo>();
    public Comparator<JobQueueJobInProgressListener.JobSchedulingInfo> comparator;
    int maxJobsToInit;
    int maxJobsToAccept;
    int maxJobsPerUserToInit;
    int maxJobsPerUserToAccept;
    int maxActiveTasks;
    int maxActiveTasksPerUser;
    private static final Comparator<JobQueueJobInProgressListener.JobSchedulingInfo> STARTTIME_JOB_COMPARATOR = new Comparator<JobQueueJobInProgressListener.JobSchedulingInfo>(){

        @Override
        public int compare(JobQueueJobInProgressListener.JobSchedulingInfo o1, JobQueueJobInProgressListener.JobSchedulingInfo o2) {
            if (o1.getStartTime() < o2.getStartTime()) {
                return -1;
            }
            return o1.getStartTime() == o2.getStartTime() ? o1.getJobID().compareTo((ID)o2.getJobID()) : 1;
        }
    };

    public CapacitySchedulerQueue(String queueName, CapacitySchedulerConf conf) {
        this.queueName = queueName;
        this.supportsPriorities = conf.isPrioritySupported(queueName);
        this.initializeQueue(conf);
        this.comparator = this.supportsPriorities ? JobQueueJobInProgressListener.FIFO_JOB_QUEUE_COMPARATOR : STARTTIME_JOB_COMPARATOR;
        this.waitingJobs = new TreeMap<JobQueueJobInProgressListener.JobSchedulingInfo, JobInProgress>(this.comparator);
        this.initializingJobs = new TreeMap<JobQueueJobInProgressListener.JobSchedulingInfo, JobInProgress>(this.comparator);
        this.runningJobs = new TreeMap<JobQueueJobInProgressListener.JobSchedulingInfo, JobInProgress>(this.comparator);
        this.mapSlots = new SlotsUsage();
        this.reduceSlots = new SlotsUsage();
    }

    synchronized void init(float capacityPercent, float maxCapacityPercent, int ulMin, float ulMinFactor, int maxJobsToInit, int maxJobsPerUserToInit, int maxActiveTasks, int maxActiveTasksPerUser, int maxJobsToAccept, int maxJobsPerUserToAccept) {
        this.capacityPercent = capacityPercent;
        this.maxCapacityPercent = maxCapacityPercent;
        this.ulMin = ulMin;
        this.ulMinFactor = ulMinFactor;
        this.maxJobsToInit = maxJobsToInit;
        this.maxJobsPerUserToInit = maxJobsPerUserToInit;
        this.maxActiveTasks = maxActiveTasks;
        this.maxActiveTasksPerUser = maxActiveTasksPerUser;
        this.maxJobsToAccept = maxJobsToAccept;
        this.maxJobsPerUserToAccept = maxJobsPerUserToAccept;
        LOG.info((Object)("Initializing '" + this.queueName + "' queue with " + "cap=" + capacityPercent + ", " + "maxCap=" + maxCapacityPercent + ", " + "ulMin=" + ulMin + ", " + "ulMinFactor=" + ulMinFactor + ", " + "supportsPriorities=" + this.supportsPriorities + ", " + "maxJobsToInit=" + maxJobsToInit + ", " + "maxJobsToAccept=" + maxJobsToAccept + ", " + "maxActiveTasks=" + maxActiveTasks + ", " + "maxJobsPerUserToInit=" + maxJobsPerUserToInit + ", " + "maxJobsPerUserToAccept=" + maxJobsPerUserToAccept + ", " + "maxActiveTasksPerUser=" + maxActiveTasksPerUser));
        if (maxActiveTasks < maxActiveTasksPerUser || maxJobsToInit < maxJobsPerUserToInit || maxJobsToAccept < maxJobsPerUserToAccept) {
            throw new IllegalArgumentException("Illegal queue configuration for queue '" + this.queueName + "'");
        }
    }

    synchronized void initializeQueue(CapacitySchedulerQueue other) {
        this.init(other.capacityPercent, other.maxCapacityPercent, other.ulMin, other.ulMinFactor, other.maxJobsToInit, other.maxJobsPerUserToInit, other.maxActiveTasks, other.maxActiveTasksPerUser, other.maxJobsToAccept, other.maxJobsPerUserToAccept);
    }

    synchronized void initializeQueue(CapacitySchedulerConf conf) {
        float capacityPercent = conf.getCapacity(this.queueName);
        float maxCapacityPercent = conf.getMaxCapacity(this.queueName);
        int ulMin = conf.getMinimumUserLimitPercent(this.queueName);
        float ulMinFactor = conf.getUserLimitFactor(this.queueName);
        int maxSystemJobs = conf.getMaxSystemJobs();
        int maxJobsToInit = (int)Math.ceil((double)((float)maxSystemJobs * capacityPercent) / 100.0);
        int maxJobsPerUserToInit = (int)Math.ceil((double)((float)maxSystemJobs * capacityPercent) / 100.0 * (double)ulMin / 100.0);
        int maxActiveTasks = conf.getMaxInitializedActiveTasks(this.queueName);
        int maxActiveTasksPerUser = conf.getMaxInitializedActiveTasksPerUser(this.queueName);
        int jobInitToAcceptFactor = conf.getInitToAcceptJobsFactor(this.queueName);
        int maxJobsToAccept = maxJobsToInit * jobInitToAcceptFactor;
        int maxJobsPerUserToAccept = maxJobsPerUserToInit * jobInitToAcceptFactor;
        this.init(capacityPercent, maxCapacityPercent, ulMin, ulMinFactor, maxJobsToInit, maxJobsPerUserToInit, maxActiveTasks, maxActiveTasksPerUser, maxJobsToAccept, maxJobsPerUserToAccept);
    }

    String getQueueName() {
        return this.queueName;
    }

    float getCapacityPercent() {
        return this.capacityPercent;
    }

    void resetSlotsUsage(TaskType taskType) {
        if (taskType == TaskType.MAP) {
            this.mapSlots.reset();
        } else if (taskType == TaskType.REDUCE) {
            this.reduceSlots.reset();
        } else {
            throw new IllegalArgumentException("Illegal taskType=" + taskType);
        }
    }

    int getCapacity(TaskType taskType) {
        if (taskType == TaskType.MAP) {
            return this.mapSlots.getCapacity();
        }
        if (taskType == TaskType.REDUCE) {
            return this.reduceSlots.getCapacity();
        }
        throw new IllegalArgumentException("Illegal taskType=" + taskType);
    }

    int getNumRunningTasks(TaskType taskType) {
        if (taskType == TaskType.MAP) {
            return this.mapSlots.getNumRunningTasks();
        }
        if (taskType == TaskType.REDUCE) {
            return this.reduceSlots.getNumRunningTasks();
        }
        throw new IllegalArgumentException("Illegal taskType=" + taskType);
    }

    int getNumSlotsOccupied(TaskType taskType) {
        if (taskType == TaskType.MAP) {
            return this.mapSlots.getNumSlotsOccupied();
        }
        if (taskType == TaskType.REDUCE) {
            return this.reduceSlots.getNumSlotsOccupied();
        }
        throw new IllegalArgumentException("Illegal taskType=" + taskType);
    }

    int getMaxCapacity(TaskType taskType) {
        if (taskType == TaskType.MAP) {
            return this.mapSlots.getMaxCapacity();
        }
        if (taskType == TaskType.REDUCE) {
            return this.reduceSlots.getMaxCapacity();
        }
        throw new IllegalArgumentException("Illegal taskType=" + taskType);
    }

    int getNumSlotsOccupiedByUser(String user, TaskType taskType) {
        if (taskType == TaskType.MAP) {
            return this.mapSlots.getNumSlotsOccupiedByUser(user);
        }
        if (taskType == TaskType.REDUCE) {
            return this.reduceSlots.getNumSlotsOccupiedByUser(user);
        }
        throw new IllegalArgumentException("Illegal taskType=" + taskType);
    }

    int getNumActiveUsersByTaskType(TaskType taskType) {
        if (taskType == TaskType.MAP) {
            return this.mapSlots.getNumActiveUsers();
        }
        if (taskType == TaskType.REDUCE) {
            return this.reduceSlots.getNumActiveUsers();
        }
        throw new IllegalArgumentException("Illegal taskType=" + taskType);
    }

    void jobAdded(JobInProgress job) {
        String user = job.getProfile().getUser();
        Integer i = this.numJobsByUser.get(user);
        if (null == i) {
            i = 1;
            this.mapSlots.numSlotsOccupiedByUser.put(user, 0);
            this.reduceSlots.numSlotsOccupiedByUser.put(user, 0);
        } else {
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        this.numJobsByUser.put(user, i);
    }

    int getNumJobsByUser(String user) {
        Integer numJobs = this.numJobsByUser.get(user);
        return numJobs != null ? numJobs : 0;
    }

    void jobCompleted(JobInProgress job) {
        Integer i;
        String user = job.getProfile().getUser();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Job to be removed for user " + user));
        }
        Integer n = i = this.numJobsByUser.get(job.getProfile().getUser());
        Integer n2 = i = Integer.valueOf(i - 1);
        if (0 == i) {
            this.numJobsByUser.remove(user);
            this.mapSlots.numSlotsOccupiedByUser.remove(user);
            this.reduceSlots.numSlotsOccupiedByUser.remove(user);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No more jobs for user, number of users = " + this.numJobsByUser.size()));
            }
        } else {
            this.numJobsByUser.put(user, i);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("User still has " + i + " jobs, number of users = " + this.numJobsByUser.size()));
            }
        }
    }

    void update(TaskType type, JobInProgress job, String user, int numRunningTasks, int numSlotsOccupied) {
        boolean pendingTasks = false;
        if (type == TaskType.MAP) {
            if (job.pendingMaps() > 0) {
                pendingTasks = true;
            }
            this.mapSlots.updateSlotsUsage(user, pendingTasks, numRunningTasks, numSlotsOccupied);
        } else if (type == TaskType.REDUCE) {
            if (job.scheduleReduces() && job.pendingReduces() > 0) {
                pendingTasks = true;
            }
            this.reduceSlots.updateSlotsUsage(user, pendingTasks, numRunningTasks, numSlotsOccupied);
        }
    }

    void updateAll(int mapClusterCapacity, int reduceClusterCapacity, CapacityTaskScheduler.TaskSchedulingMgr mapScheduler, CapacityTaskScheduler.TaskSchedulingMgr reduceScheduler) {
        this.mapSlots.updateCapacities(this.capacityPercent, this.maxCapacityPercent, mapClusterCapacity);
        this.reduceSlots.updateCapacities(this.capacityPercent, this.maxCapacityPercent, reduceClusterCapacity);
        this.resetSlotsUsage(TaskType.MAP);
        this.resetSlotsUsage(TaskType.REDUCE);
        Collection<JobInProgress> jobs = this.getRunningJobs();
        for (JobInProgress j : jobs) {
            if (j.getStatus().getRunState() != 1) continue;
            int numMapsRunningForThisJob = mapScheduler.getRunningTasks(j);
            int numReducesRunningForThisJob = reduceScheduler.getRunningTasks(j);
            int numRunningMapSlots = numMapsRunningForThisJob * mapScheduler.getSlotsPerTask(j);
            int numRunningReduceSlots = numReducesRunningForThisJob * reduceScheduler.getSlotsPerTask(j);
            int numMapSlotsForThisJob = mapScheduler.getSlotsOccupied(j);
            int numReduceSlotsForThisJob = reduceScheduler.getSlotsOccupied(j);
            int numReservedMapSlotsForThisJob = mapScheduler.getNumReservedTaskTrackers(j) * mapScheduler.getSlotsPerTask(j);
            int numReservedReduceSlotsForThisJob = reduceScheduler.getNumReservedTaskTrackers(j) * reduceScheduler.getSlotsPerTask(j);
            j.setSchedulingInfo((Object)CapacityTaskScheduler.getJobQueueSchedInfo(numMapsRunningForThisJob, numRunningMapSlots, numReservedMapSlotsForThisJob, numReducesRunningForThisJob, numRunningReduceSlots, numReservedReduceSlotsForThisJob));
            this.update(TaskType.MAP, j, j.getProfile().getUser(), numMapsRunningForThisJob, numMapSlotsForThisJob);
            this.update(TaskType.REDUCE, j, j.getProfile().getUser(), numReducesRunningForThisJob, numReduceSlotsForThisJob);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)String.format(this.queueName + " - updateQSI: job %s: run(m)=%d, " + "occupied(m)=%d, run(r)=%d, occupied(r)=%d, finished(m)=%d," + " finished(r)=%d, failed(m)=%d, failed(r)=%d, " + "spec(m)=%d, spec(r)=%d, total(m)=%d, total(r)=%d", j.getJobID().toString(), numMapsRunningForThisJob, numMapSlotsForThisJob, numReducesRunningForThisJob, numReduceSlotsForThisJob, j.finishedMaps(), j.finishedReduces(), j.failedMapTasks, j.failedReduceTasks, j.speculativeMapTasks, j.speculativeReduceTasks, j.numMapTasks, j.numReduceTasks));
        }
    }

    boolean doesQueueSupportPriorities() {
        return this.supportsPriorities;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Queue configuration\n");
        sb.append("Capacity Percentage: ");
        sb.append(this.capacityPercent);
        sb.append("%\n");
        sb.append("User Limit: " + this.ulMin + "%\n");
        sb.append("Priority Supported: " + (this.doesQueueSupportPriorities() ? "YES" : "NO") + "\n");
        sb.append("-------------\n");
        sb.append("Map tasks\n");
        sb.append(this.mapSlots.toString());
        sb.append("-------------\n");
        sb.append("Reduce tasks\n");
        sb.append(this.reduceSlots.toString());
        sb.append("-------------\n");
        sb.append("Job info\n");
        sb.append("Number of Waiting Jobs: " + this.getNumWaitingJobs() + "\n");
        sb.append("Number of Initializing Jobs: " + this.getNumInitializingJobs() + "\n");
        sb.append("Number of users who have submitted jobs: " + this.numJobsByUser.size() + "\n");
        return sb.toString();
    }

    synchronized Collection<JobInProgress> getWaitingJobs() {
        return Collections.unmodifiableCollection(new LinkedList<JobInProgress>(this.waitingJobs.values()));
    }

    synchronized Collection<JobInProgress> getInitializingJobs() {
        return Collections.unmodifiableCollection(new LinkedList<JobInProgress>(this.initializingJobs.values()));
    }

    synchronized Collection<JobInProgress> getRunningJobs() {
        return Collections.unmodifiableCollection(new LinkedList<JobInProgress>(this.runningJobs.values()));
    }

    synchronized int getNumActiveTasks() {
        return this.activeTasks;
    }

    synchronized int getNumRunningJobs() {
        return this.runningJobs.size();
    }

    synchronized int getNumInitializingJobs() {
        return this.initializingJobs.size();
    }

    synchronized int getNumInitializingJobsByUser(String user) {
        UserInfo userInfo = this.users.get(user);
        return userInfo == null ? 0 : userInfo.getNumInitializingJobs();
    }

    synchronized int getNumRunningJobsByUser(String user) {
        UserInfo userInfo = this.users.get(user);
        return userInfo == null ? 0 : userInfo.getNumRunningJobs();
    }

    synchronized int getNumActiveTasksByUser(String user) {
        UserInfo userInfo = this.users.get(user);
        return userInfo == null ? 0 : userInfo.getNumActiveTasks();
    }

    synchronized int getNumWaitingJobsByUser(String user) {
        UserInfo userInfo = this.users.get(user);
        return userInfo == null ? 0 : userInfo.getNumWaitingJobs();
    }

    synchronized void addInitializingJob(JobInProgress job) {
        JobQueueJobInProgressListener.JobSchedulingInfo jobSchedInfo = new JobQueueJobInProgressListener.JobSchedulingInfo(job);
        if (!this.waitingJobs.containsKey(jobSchedInfo)) {
            LOG.warn((Object)("Cannot find job " + job.getJobID() + " in list of waiting jobs!"));
            return;
        }
        if (this.initializingJobs.containsKey(jobSchedInfo)) {
            LOG.warn((Object)("job " + job.getJobID() + " already being init'ed in queue'" + this.queueName + "'!"));
            return;
        }
        this.initializingJobs.put(jobSchedInfo, job);
        this.addJob(jobSchedInfo, job);
        if (LOG.isDebugEnabled()) {
            String user = job.getProfile().getUser();
            LOG.debug((Object)("addInitializingJob: job=" + job.getJobID() + " user=" + user + " queue=" + this.queueName + " qWaitJobs=" + this.getNumWaitingJobs() + " qInitJobs=" + this.getNumInitializingJobs() + " qRunJobs=" + this.getNumRunningJobs() + " qActiveTasks=" + this.getNumActiveTasks() + " uWaitJobs=" + this.getNumWaitingJobsByUser(user) + " uInitJobs=" + this.getNumInitializingJobsByUser(user) + " uRunJobs=" + this.getNumRunningJobsByUser(user) + " uActiveTasks=" + this.getNumActiveTasksByUser(user)));
        }
        this.removeWaitingJob(jobSchedInfo, 4);
    }

    synchronized JobInProgress removeInitializingJob(JobQueueJobInProgressListener.JobSchedulingInfo jobSchedInfo, int runState) {
        JobInProgress job = this.initializingJobs.remove(jobSchedInfo);
        if (job != null) {
            String user = job.getProfile().getUser();
            UserInfo userInfo = this.users.get(user);
            userInfo.removeInitializingJob(jobSchedInfo);
            if (runState != 1) {
                this.finishJob(jobSchedInfo, job);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("removeInitializingJob: job=" + job.getJobID() + " user=" + user + " queue=" + this.queueName + " qWaitJobs=" + this.getNumWaitingJobs() + " qInitJobs=" + this.getNumInitializingJobs() + " qRunJobs=" + this.getNumRunningJobs() + " qActiveTasks=" + this.getNumActiveTasks() + " uWaitJobs=" + this.getNumWaitingJobsByUser(user) + " uInitJobs=" + this.getNumInitializingJobsByUser(user) + " uRunJobs=" + this.getNumRunningJobsByUser(user) + " uActiveTasks=" + this.getNumActiveTasksByUser(user)));
            }
        }
        return job;
    }

    synchronized void addRunningJob(JobInProgress job) {
        JobQueueJobInProgressListener.JobSchedulingInfo jobSchedInfo = new JobQueueJobInProgressListener.JobSchedulingInfo(job);
        if (this.runningJobs.containsKey(jobSchedInfo)) {
            LOG.info((Object)("job " + job.getJobID() + " already running in queue'" + this.queueName + "'!"));
            return;
        }
        this.runningJobs.put(jobSchedInfo, job);
        String user = job.getProfile().getUser();
        UserInfo userInfo = this.users.get(user);
        userInfo.jobInitialized(jobSchedInfo, job);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("addRunningJob: job=" + job.getJobID() + " user=" + user + " queue=" + this.queueName + " qWaitJobs=" + this.getNumWaitingJobs() + " qInitJobs=" + this.getNumInitializingJobs() + " qRunJobs=" + this.getNumRunningJobs() + " qActiveTasks=" + this.getNumActiveTasks() + " uWaitJobs=" + this.getNumWaitingJobsByUser(user) + " uInitJobs=" + this.getNumInitializingJobsByUser(user) + " uRunJobs=" + this.getNumRunningJobsByUser(user) + " uActiveTasks=" + this.getNumActiveTasksByUser(user)));
        }
        this.removeInitializingJob(jobSchedInfo, 1);
    }

    private synchronized void addJob(JobQueueJobInProgressListener.JobSchedulingInfo jobSchedInfo, JobInProgress job) {
        this.activeTasks += job.desiredTasks();
        String user = job.getProfile().getUser();
        UserInfo userInfo = this.users.get(user);
        userInfo.jobInitializing(jobSchedInfo, job);
    }

    private synchronized void finishJob(JobQueueJobInProgressListener.JobSchedulingInfo jobSchedInfo, JobInProgress job) {
        String user = job.getProfile().getUser();
        UserInfo userInfo = this.users.get(user);
        userInfo.jobCompleted(jobSchedInfo, job);
        if (userInfo.isInactive()) {
            this.users.remove(userInfo);
        }
        this.activeTasks -= job.desiredTasks();
    }

    synchronized JobInProgress removeRunningJob(JobQueueJobInProgressListener.JobSchedulingInfo jobSchedInfo, int runState) {
        JobInProgress job = this.runningJobs.remove(jobSchedInfo);
        if (job != null) {
            String user = job.getProfile().getUser();
            this.finishJob(jobSchedInfo, job);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("removeRunningJob: job=" + job.getJobID() + " user=" + user + " queue=" + this.queueName + " qWaitJobs=" + this.getNumWaitingJobs() + " qInitJobs=" + this.getNumInitializingJobs() + " qRunJobs=" + this.getNumRunningJobs() + " qActiveTasks=" + this.getNumActiveTasks() + " uWaitJobs=" + this.getNumWaitingJobsByUser(user) + " uInitJobs=" + this.getNumInitializingJobsByUser(user) + " uRunJobs=" + this.getNumRunningJobsByUser(user) + " uActiveTasks=" + this.getNumActiveTasksByUser(user)));
            }
        }
        return job;
    }

    synchronized void addWaitingJob(JobInProgress job) throws IOException {
        JobQueueJobInProgressListener.JobSchedulingInfo jobSchedInfo = new JobQueueJobInProgressListener.JobSchedulingInfo(job);
        if (this.waitingJobs.containsKey(jobSchedInfo)) {
            LOG.info((Object)("job " + job.getJobID() + " already waiting in queue '" + this.queueName + "'!"));
            return;
        }
        String user = job.getProfile().getUser();
        this.checkJobSubmissionLimits(job, user);
        this.waitingJobs.put(jobSchedInfo, job);
        UserInfo userInfo = this.users.get(user);
        if (userInfo == null) {
            userInfo = new UserInfo(this.comparator);
            this.users.put(user, userInfo);
        }
        userInfo.jobAdded(jobSchedInfo, job);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("addWaitingJob: job=" + job.getJobID() + " user=" + user + " queue=" + this.queueName + " qWaitJobs=" + this.getNumWaitingJobs() + " qInitJobs=" + this.getNumInitializingJobs() + " qRunJobs=" + this.getNumRunningJobs() + " qActiveTasks=" + this.getNumActiveTasks() + " uWaitJobs=" + this.getNumWaitingJobsByUser(user) + " uInitJobs=" + this.getNumInitializingJobsByUser(user) + " uRunJobs=" + this.getNumRunningJobsByUser(user) + " uActiveTasks=" + this.getNumActiveTasksByUser(user)));
        }
    }

    synchronized JobInProgress removeWaitingJob(JobQueueJobInProgressListener.JobSchedulingInfo jobSchedInfo, int unused) {
        JobInProgress job = this.waitingJobs.remove(jobSchedInfo);
        if (job != null) {
            String user = job.getProfile().getUser();
            UserInfo userInfo = this.users.get(user);
            userInfo.removeWaitingJob(jobSchedInfo);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("removeWaitingJob: job=" + job.getJobID() + " user=" + user + " queue=" + this.queueName + " qWaitJobs=" + this.getNumWaitingJobs() + " qInitJobs=" + this.getNumInitializingJobs() + " qRunJobs=" + this.getNumRunningJobs() + " qActiveTasks=" + this.getNumActiveTasks() + " uWaitJobs=" + this.getNumWaitingJobsByUser(user) + " uInitJobs=" + this.getNumInitializingJobsByUser(user) + " uRunJobs=" + this.getNumRunningJobsByUser(user) + " uActiveTasks=" + this.getNumActiveTasksByUser(user)));
            }
        }
        return job;
    }

    synchronized int getNumActiveUsers() {
        return this.users.size();
    }

    synchronized int getNumWaitingJobs() {
        return this.waitingJobs.size();
    }

    Comparator<JobQueueJobInProgressListener.JobSchedulingInfo> getComparator() {
        return this.comparator;
    }

    boolean assignSlotsToQueue(TaskType taskType, int numSlots) {
        if (this.getMaxCapacity(taskType) > 0 && this.getNumSlotsOccupied(taskType) + numSlots > this.getMaxCapacity(taskType)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Queue " + this.queueName + " " + "has reached its  max " + taskType + " capacity"));
                LOG.debug((Object)("Current running tasks " + this.getCapacity(taskType)));
            }
            return false;
        }
        return true;
    }

    boolean assignSlotsToJob(TaskType taskType, JobInProgress job, String user) {
        int numSlotsRequested = job.getNumSlotsPerTask(taskType);
        if (!this.assignSlotsToQueue(taskType, numSlotsRequested)) {
            return false;
        }
        int queueCapacity = Math.max(this.getCapacity(taskType), numSlotsRequested);
        int queueSlotsOccupied = this.getNumSlotsOccupied(taskType);
        int currentCapacity = queueSlotsOccupied < queueCapacity ? queueCapacity : queueSlotsOccupied + numSlotsRequested;
        int activeUsers = Math.max(1, this.getNumActiveUsersByTaskType(taskType));
        int limit = Math.min(Math.max(CapacitySchedulerQueue.divideAndCeil(currentCapacity, activeUsers), CapacitySchedulerQueue.divideAndCeil(this.ulMin * currentCapacity, 100)), (int)((float)queueCapacity * this.ulMinFactor));
        if (this.getNumSlotsOccupiedByUser(user, taskType) + numSlotsRequested > limit) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("User " + user + " is over limit for queue=" + this.queueName + " queueCapacity=" + queueCapacity + " num slots occupied=" + this.getNumSlotsOccupiedByUser(user, taskType) + " limit=" + limit + " numSlotsRequested=" + numSlotsRequested + " currentCapacity=" + currentCapacity + " numActiveUsers=" + this.getNumActiveUsersByTaskType(taskType)));
            }
            return false;
        }
        return true;
    }

    private static int divideAndCeil(int a, int b) {
        if (b == 0) {
            LOG.info((Object)("divideAndCeil called with a=" + a + " b=" + b));
            return 0;
        }
        return (a + (b - 1)) / b;
    }

    synchronized void checkJobSubmissionLimits(JobInProgress job, String user) throws IOException {
        int userRunningJobs;
        int userInitializingJobs;
        int queueRunningJobs;
        int queueInitializingJobs;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("checkJobSubmissionLimits - qWaitJobs=" + this.getNumWaitingJobs() + " " + "qInitJobs=" + this.getNumInitializingJobs() + " " + "qRunJobs=" + this.getNumRunningJobs() + " " + "maxJobsToAccept=" + this.maxJobsToAccept + "user=" + user + " " + "uWaitJobs=" + this.getNumWaitingJobsByUser(user) + " " + "uRunJobs=" + this.getNumRunningJobsByUser(user) + " " + "maxJobsPerUserToAccept=" + this.maxJobsPerUserToAccept + " " + ""));
        }
        if (job.desiredTasks() > this.maxActiveTasksPerUser) {
            throw new IOException("Job '" + job.getJobID() + "' from user '" + user + "' rejected since it has " + job.desiredTasks() + " tasks which" + " exceeds the limit of " + this.maxActiveTasksPerUser + " tasks per-user which can be initialized for queue '" + this.queueName + "'");
        }
        int queueWaitingJobs = this.getNumWaitingJobs();
        if (queueWaitingJobs + (queueInitializingJobs = this.getNumInitializingJobs()) + (queueRunningJobs = this.getNumRunningJobs()) >= this.maxJobsToAccept) {
            throw new IOException("Job '" + job.getJobID() + "' from user '" + user + "' rejected since queue '" + this.queueName + "' already has " + queueWaitingJobs + " waiting jobs, " + queueInitializingJobs + " initializing jobs and " + queueRunningJobs + " running jobs - Exceeds limit of " + this.maxJobsToAccept + " jobs to accept");
        }
        int userWaitingJobs = this.getNumWaitingJobsByUser(user);
        if (userWaitingJobs + (userInitializingJobs = this.getNumInitializingJobsByUser(user)) + (userRunningJobs = this.getNumRunningJobsByUser(user)) >= this.maxJobsPerUserToAccept) {
            throw new IOException("Job '" + job.getJobID() + "' rejected since user '" + user + "' already has " + userWaitingJobs + " waiting jobs, " + userInitializingJobs + " initializing jobs and " + userRunningJobs + " running jobs - " + " Exceeds limit of " + this.maxJobsPerUserToAccept + " jobs to accept" + " in queue '" + this.queueName + "' per user");
        }
    }

    synchronized boolean initializeJobForQueue(JobInProgress job) {
        int initializingJobs;
        int runningJobs = this.getNumRunningJobs();
        if (runningJobs + (initializingJobs = this.getNumInitializingJobs()) >= this.maxJobsToInit) {
            LOG.info((Object)(this.getQueueName() + " already has " + runningJobs + " running jobs and " + initializingJobs + " initializing jobs;" + " cannot initialize " + job.getJobID() + " since it will exceeed limit of " + this.maxJobsToInit + " initialized jobs for this queue"));
            return false;
        }
        if (this.activeTasks + job.desiredTasks() > this.maxActiveTasks) {
            LOG.info((Object)("Queue '" + this.getQueueName() + "' has " + this.activeTasks + " active tasks, cannot initialize job '" + job.getJobID() + "' for user '" + job.getProfile().getUser() + "' with " + job.desiredTasks() + " tasks since it will exceed limit of " + this.maxActiveTasks + " active tasks for this queue"));
            return false;
        }
        return true;
    }

    synchronized boolean initializeJobForUser(JobInProgress job) {
        int userInitializingJobs;
        String user = job.getProfile().getUser();
        int userRunningJobs = this.getNumRunningJobsByUser(user);
        if (userRunningJobs + (userInitializingJobs = this.getNumInitializingJobsByUser(user)) >= this.maxJobsPerUserToInit) {
            LOG.info((Object)(this.getQueueName() + " already has " + userRunningJobs + " running jobs and " + userInitializingJobs + " initializing jobs" + " for user " + user + "; cannot initialize " + job.getJobID() + " since it will exceeed limit of " + this.maxJobsPerUserToInit + " initialized jobs per user for this queue"));
            return false;
        }
        int userActiveTasks = this.getNumActiveTasksByUser(user);
        if (userActiveTasks + job.desiredTasks() > this.maxActiveTasksPerUser) {
            LOG.info((Object)(this.getQueueName() + " has " + userActiveTasks + " active tasks for user " + user + ", cannot initialize " + job.getJobID() + " with " + job.desiredTasks() + " tasks since it will exceed limit of " + this.maxActiveTasksPerUser + " active tasks per user for this queue"));
            return false;
        }
        return true;
    }

    static class UserInfo {
        Map<JobQueueJobInProgressListener.JobSchedulingInfo, JobInProgress> waitingJobs;
        Map<JobQueueJobInProgressListener.JobSchedulingInfo, JobInProgress> initializingJobs;
        Map<JobQueueJobInProgressListener.JobSchedulingInfo, JobInProgress> runningJobs;
        int activeTasks;

        public UserInfo(Comparator<JobQueueJobInProgressListener.JobSchedulingInfo> comparator) {
            this.waitingJobs = new TreeMap<JobQueueJobInProgressListener.JobSchedulingInfo, JobInProgress>(comparator);
            this.initializingJobs = new TreeMap<JobQueueJobInProgressListener.JobSchedulingInfo, JobInProgress>(comparator);
            this.runningJobs = new TreeMap<JobQueueJobInProgressListener.JobSchedulingInfo, JobInProgress>(comparator);
        }

        int getNumInitializingJobs() {
            return this.initializingJobs.size();
        }

        int getNumRunningJobs() {
            return this.runningJobs.size();
        }

        int getNumWaitingJobs() {
            return this.waitingJobs.size();
        }

        int getNumActiveTasks() {
            return this.activeTasks;
        }

        public void jobAdded(JobQueueJobInProgressListener.JobSchedulingInfo jobSchedInfo, JobInProgress job) {
            this.waitingJobs.put(jobSchedInfo, job);
        }

        public void removeWaitingJob(JobQueueJobInProgressListener.JobSchedulingInfo jobSchedInfo) {
            this.waitingJobs.remove(jobSchedInfo);
        }

        public void jobInitializing(JobQueueJobInProgressListener.JobSchedulingInfo jobSchedInfo, JobInProgress job) {
            if (!this.initializingJobs.containsKey(jobSchedInfo)) {
                this.initializingJobs.put(jobSchedInfo, job);
                this.activeTasks += job.desiredTasks();
            }
        }

        public void removeInitializingJob(JobQueueJobInProgressListener.JobSchedulingInfo jobSchedInfo) {
            this.initializingJobs.remove(jobSchedInfo);
        }

        public void jobInitialized(JobQueueJobInProgressListener.JobSchedulingInfo jobSchedInfo, JobInProgress job) {
            this.runningJobs.put(jobSchedInfo, job);
        }

        public void jobCompleted(JobQueueJobInProgressListener.JobSchedulingInfo jobSchedInfo, JobInProgress job) {
            this.runningJobs.remove(jobSchedInfo);
            this.activeTasks -= job.desiredTasks();
        }

        boolean isInactive() {
            return this.activeTasks == 0 && this.runningJobs.size() == 0 && this.waitingJobs.size() == 0 && this.initializingJobs.size() == 0;
        }
    }

    private static class SlotsUsage {
        private int capacity = 0;
        int numRunningTasks = 0;
        int numSlotsOccupied = 0;
        private int maxCapacity = -1;
        Set<String> users = new HashSet<String>();
        Map<String, Integer> numSlotsOccupiedByUser = new HashMap<String, Integer>();

        private SlotsUsage() {
        }

        void reset() {
            this.numRunningTasks = 0;
            this.numSlotsOccupied = 0;
            this.users.clear();
            this.numSlotsOccupiedByUser.clear();
        }

        int getCapacity() {
            return this.capacity;
        }

        void setCapacity(int capacity) {
            this.capacity = capacity;
        }

        int getNumRunningTasks() {
            return this.numRunningTasks;
        }

        int getNumSlotsOccupied() {
            return this.numSlotsOccupied;
        }

        int getNumActiveUsers() {
            return this.users.size();
        }

        public String toString() {
            float occupiedSlotsAsPercent = this.getCapacity() != 0 ? (float)this.numSlotsOccupied * 100.0f / (float)this.getCapacity() : 0.0f;
            StringBuffer sb = new StringBuffer();
            sb.append("Capacity: " + this.capacity + " slots\n");
            if (this.getMaxCapacity() >= 0) {
                sb.append("Maximum capacity: " + this.getMaxCapacity() + " slots\n");
            }
            sb.append(String.format("Used capacity: %d (%.1f%% of Capacity)\n", this.numSlotsOccupied, Float.valueOf(occupiedSlotsAsPercent)));
            sb.append(String.format("Running tasks: %d\n", this.numRunningTasks));
            if (this.numSlotsOccupied != 0) {
                sb.append("Active users:\n");
                for (Map.Entry<String, Integer> entry : this.numSlotsOccupiedByUser.entrySet()) {
                    if (entry.getValue() == null || entry.getValue() <= 0) continue;
                    sb.append("User '" + entry.getKey() + "': ");
                    int numSlotsOccupiedByThisUser = entry.getValue();
                    float p = (float)numSlotsOccupiedByThisUser * 100.0f / (float)this.numSlotsOccupied;
                    sb.append(String.format("%d (%.1f%% of used capacity)\n", numSlotsOccupiedByThisUser, Float.valueOf(p)));
                }
            }
            return sb.toString();
        }

        int getMaxCapacity() {
            return this.maxCapacity;
        }

        void setMaxCapacity(int maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        int getNumSlotsOccupiedByUser(String user) {
            Integer slots = this.numSlotsOccupiedByUser.get(user);
            return slots != null ? slots : 0;
        }

        void updateCapacities(float capacityPercent, float maxCapacityPercent, int clusterCapacity) {
            this.setCapacity((int)(capacityPercent * (float)clusterCapacity / 100.0f));
            if (maxCapacityPercent > 0.0f) {
                this.setMaxCapacity((int)(maxCapacityPercent * (float)clusterCapacity / 100.0f));
            }
        }

        void updateSlotsUsage(String user, boolean pendingTasks, int numRunningTasks, int numSlotsOccupied) {
            this.numRunningTasks += numRunningTasks;
            this.numSlotsOccupied += numSlotsOccupied;
            Integer i = this.numSlotsOccupiedByUser.get(user);
            int slots = numSlotsOccupied + (i == null ? 0 : i);
            this.numSlotsOccupiedByUser.put(user, slots);
            if (pendingTasks) {
                this.users.add(user);
            }
        }
    }
}

