/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.watchmaker.swing.evolutionmonitor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Paint;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.xy.DeviationRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYIntervalSeries;
import org.jfree.data.xy.XYIntervalSeriesCollection;
import org.uncommons.watchmaker.framework.EvolutionObserver;
import org.uncommons.watchmaker.framework.PopulationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PopulationFitnessView
extends JPanel
implements EvolutionObserver<Object> {
    private final XYIntervalSeries meanSeries = new XYIntervalSeries((Comparable)((Object)"Mean Fitness"));
    private final XYIntervalSeries bestSeries = new XYIntervalSeries((Comparable)((Object)"Fittest Individual"));
    private final DeviationRenderer renderer = new DeviationRenderer(true, false);
    private final JFreeChart chart;

    PopulationFitnessView() {
        super(new BorderLayout());
        XYIntervalSeriesCollection dataSet = new XYIntervalSeriesCollection();
        dataSet.addSeries(this.meanSeries);
        dataSet.addSeries(this.bestSeries);
        this.chart = ChartFactory.createXYLineChart((String)"Population Fitness", (String)"Generations", (String)"Fitness", (XYDataset)dataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        this.renderer.setSeriesPaint(0, (Paint)Color.BLUE);
        this.renderer.setSeriesFillPaint(0, (Paint)Color.BLUE.brighter());
        this.renderer.setSeriesPaint(1, (Paint)Color.RED);
        this.renderer.setAlpha(0.1f);
        this.chart.getXYPlot().setRenderer((XYItemRenderer)this.renderer);
        this.chart.getXYPlot().getDomainAxis().setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        this.add((Component)this.createControls(), "South");
        this.add((Component)new ChartPanel(this.chart), "Center");
    }

    private JComponent createControls() {
        JPanel controls = new JPanel(new FlowLayout(0));
        final JCheckBox deviationCheckBox = new JCheckBox("Standard Deviation", true);
        deviationCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                Color paint = deviationCheckBox.isSelected() ? Color.BLUE.brighter() : null;
                PopulationFitnessView.this.renderer.setSeriesFillPaint(0, (Paint)paint);
            }
        });
        controls.add(deviationCheckBox);
        final JCheckBox invertCheckBox = new JCheckBox("Invert Range Axis", false);
        invertCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                PopulationFitnessView.this.chart.getXYPlot().getRangeAxis().setInverted(invertCheckBox.isSelected());
            }
        });
        controls.add(invertCheckBox);
        controls.setBorder(BorderFactory.createTitledBorder("Display Options"));
        return controls;
    }

    public void populationUpdate(PopulationData<? extends Object> populationData) {
        int generation = populationData.getGenerationNumber();
        double mean = populationData.getMeanFitness();
        double meanMin = mean - populationData.getFitnessStandardDeviation();
        double meanMax = mean + populationData.getFitnessStandardDeviation();
        this.meanSeries.add((double)generation, (double)generation, (double)generation, mean, meanMin, meanMax);
        double best = populationData.getBestCandidateFitness();
        this.bestSeries.add((double)generation, (double)generation, (double)generation, best, best, best);
    }
}

