/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.watchmaker.swing.evolutionmonitor;

import java.awt.Component;
import java.awt.Window;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.uncommons.watchmaker.framework.EvolutionObserver;
import org.uncommons.watchmaker.framework.PopulationData;
import org.uncommons.watchmaker.framework.interactive.Renderer;
import org.uncommons.watchmaker.swing.evolutionmonitor.FittestCandidateView;
import org.uncommons.watchmaker.swing.evolutionmonitor.PopulationFitnessView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvolutionMonitor<T>
implements EvolutionObserver<T> {
    private final List<EvolutionObserver<? super T>> views = new LinkedList<EvolutionObserver<? super T>>();
    private final JComponent monitorComponent = new JTabbedPane();
    private Window window = null;

    public EvolutionMonitor() {
        PopulationFitnessView fitnessView = new PopulationFitnessView();
        this.monitorComponent.add("Population Fitness", fitnessView);
        this.views.add(fitnessView);
    }

    public EvolutionMonitor(Renderer<T, JComponent> renderer) {
        this();
        FittestCandidateView<T> candidateView = new FittestCandidateView<T>(renderer);
        this.monitorComponent.add("Fittest Candidate So Far", candidateView);
        this.views.add(candidateView);
    }

    public void populationUpdate(PopulationData<? extends T> populationData) {
        for (EvolutionObserver<? super T> evolutionObserver : this.views) {
            evolutionObserver.populationUpdate(populationData);
        }
    }

    public JComponent getGUIComponent() {
        return this.monitorComponent;
    }

    public void showInFrame(final String title) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JFrame frame = new JFrame(title);
                frame.setDefaultCloseOperation(2);
                EvolutionMonitor.this.showWindow(frame);
            }
        });
    }

    public void showInDialog(final JFrame owner, final String title, final boolean modal) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JDialog dialog = new JDialog(owner, title, modal);
                dialog.setDefaultCloseOperation(2);
                EvolutionMonitor.this.showWindow(dialog);
            }
        });
    }

    private void showWindow(Window newWindow) {
        if (this.window != null) {
            this.window.remove(this.getGUIComponent());
            this.window.setVisible(false);
            this.window.dispose();
            this.window = null;
        }
        newWindow.add((Component)this.getGUIComponent(), "Center");
        newWindow.pack();
        newWindow.setVisible(true);
        this.window = newWindow;
    }
}

