/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.watchmaker.swing;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.uncommons.maths.AdjustableNumberGenerator;
import org.uncommons.maths.Maths;
import org.uncommons.maths.NumberGenerator;
import org.uncommons.watchmaker.framework.Probability;
import org.uncommons.watchmaker.swing.EvolutionControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProbabilityParameterControl
implements EvolutionControl {
    private final Probability defaultValue;
    private final int range;
    private final JSlider control;
    private final AdjustableNumberGenerator<Probability> numberGenerator;

    public ProbabilityParameterControl(Probability defaultValue) {
        this(Probability.ZERO, Probability.ONE, 2, defaultValue);
    }

    public ProbabilityParameterControl(Probability minimum, Probability maximum, int decimalPlaces, Probability initialValue) {
        if (initialValue.compareTo(minimum) < 0 || initialValue.compareTo(maximum) > 0) {
            throw new IllegalArgumentException("Initial value must respect minimum and maximum.");
        }
        this.defaultValue = initialValue;
        this.numberGenerator = new AdjustableNumberGenerator((Number)this.defaultValue);
        this.range = (int)Maths.raiseToPower((int)10, (int)decimalPlaces);
        this.control = this.createSlider(initialValue, minimum, maximum);
    }

    private JSlider createSlider(Probability initialValue, Probability minimum, Probability maximum) {
        int value = (int)Math.round((double)this.range * initialValue.doubleValue());
        int min = (int)Math.round((double)this.range * minimum.doubleValue());
        int max = (int)Math.round((double)this.range * maximum.doubleValue());
        final JSlider slider = new JSlider(min, max, value);
        slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Probability probability = new Probability((double)slider.getValue() / (double)ProbabilityParameterControl.this.range);
                ProbabilityParameterControl.this.numberGenerator.setValue((Number)probability);
                slider.setToolTipText(probability.toString());
            }
        });
        Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
        ((Dictionary)labels).put(min, new JLabel(minimum.toString()));
        ((Dictionary)labels).put(max, new JLabel(maximum.toString()));
        slider.setLabelTable(labels);
        slider.setPaintLabels(true);
        slider.setMajorTickSpacing(this.range / 10);
        slider.setExtent(this.range / 20);
        slider.setPaintTicks(true);
        return slider;
    }

    @Override
    public JComponent getControl() {
        return this.control;
    }

    @Override
    public void reset() {
        int value = (int)Math.round((double)this.range * this.defaultValue.doubleValue());
        this.control.setValue(value);
        this.numberGenerator.setValue((Number)this.defaultValue);
    }

    public NumberGenerator<Probability> getNumberGenerator() {
        return this.numberGenerator;
    }
}

