/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.regex;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.apache.mahout.utils.regex.RegexTransformer;

public final class URLDecodeTransformer
implements RegexTransformer {
    private final String enc;

    public URLDecodeTransformer() {
        this.enc = "UTF-8";
    }

    public URLDecodeTransformer(String encoding) {
        this.enc = encoding;
    }

    @Override
    public String transformMatch(String match) {
        try {
            return URLDecoder.decode(match, this.enc);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }
}

