/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.vectors.lucene;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.mahout.utils.vectors.TermEntry;
import org.apache.mahout.utils.vectors.TermInfo;

public class CachedTermInfo
implements TermInfo {
    private final Map<String, TermEntry> termEntries;
    private final String field;

    public CachedTermInfo(IndexReader reader, String field, int minDf, int maxDfPercent) throws IOException {
        BytesRef text;
        this.field = field;
        Terms t = MultiFields.getTerms((IndexReader)reader, (String)field);
        TermsEnum te = t.iterator(null);
        int numDocs = reader.numDocs();
        double percent = (double)(numDocs * maxDfPercent) / 100.0;
        this.termEntries = new LinkedHashMap<String, TermEntry>();
        int count = 0;
        while ((text = te.next()) != null) {
            int df = te.docFreq();
            if (df < minDf || (double)df > percent) continue;
            TermEntry entry = new TermEntry(text.utf8ToString(), count++, df);
            this.termEntries.put(entry.getTerm(), entry);
        }
    }

    @Override
    public int totalTerms(String field) {
        return this.termEntries.size();
    }

    @Override
    public TermEntry getTermEntry(String field, String term) {
        if (!this.field.equals(field)) {
            return null;
        }
        return this.termEntries.get(term);
    }

    @Override
    public Iterator<TermEntry> getAllEntries() {
        return this.termEntries.values().iterator();
    }
}

