/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.vectors.io;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.utils.vectors.io.VectorWriter;

public class SequenceFileVectorWriter
implements VectorWriter {
    private final SequenceFile.Writer writer;
    private long recNum = 0L;

    public SequenceFileVectorWriter(SequenceFile.Writer writer) {
        this.writer = writer;
    }

    @Override
    public long write(Iterable<Vector> iterable, long maxDocs) throws IOException {
        for (Vector point : iterable) {
            if (this.recNum >= maxDocs) break;
            if (point == null) continue;
            this.writer.append((Writable)new LongWritable(this.recNum++), (Writable)new VectorWritable(point));
        }
        return this.recNum;
    }

    @Override
    public void write(Vector vector) throws IOException {
        this.writer.append((Writable)new LongWritable(this.recNum++), (Writable)new VectorWritable(vector));
    }

    @Override
    public long write(Iterable<Vector> iterable) throws IOException {
        return this.write(iterable, Long.MAX_VALUE);
    }

    @Override
    public void close() throws IOException {
        Closeables.close((Closeable)this.writer, (boolean)false);
    }

    public SequenceFile.Writer getWriter() {
        return this.writer;
    }
}

