/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.vectors;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.sequencefile.PathFilters;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirIterable;
import org.apache.mahout.math.VectorWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowIdJob
extends AbstractJob {
    private static final Logger log = LoggerFactory.getLogger(RowIdJob.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        this.addInputOption();
        this.addOutputOption();
        Map parsedArgs = this.parseArguments(args);
        if (parsedArgs == null) {
            return -1;
        }
        Configuration conf = this.getConf();
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path outputPath = this.getOutputPath();
        Path indexPath = new Path(outputPath, "docIndex");
        Path matrixPath = new Path(outputPath, "matrix");
        SequenceFile.Writer indexWriter = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)indexPath, IntWritable.class, Text.class);
        SequenceFile.Writer matrixWriter = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)matrixPath, IntWritable.class, VectorWritable.class);
        try {
            IntWritable docId = new IntWritable();
            int i = 0;
            int numCols = 0;
            for (Pair record : new SequenceFileDirIterable(this.getInputPath(), PathType.LIST, PathFilters.logsCRCFilter(), null, true, conf)) {
                VectorWritable value = (VectorWritable)record.getSecond();
                docId.set(i);
                indexWriter.append((Writable)docId, (Writable)record.getFirst());
                matrixWriter.append((Writable)docId, (Writable)value);
                ++i;
                numCols = value.get().size();
            }
            log.info("Wrote out matrix with {} rows and {} columns to {}", new Object[]{i, numCols, matrixPath});
            int n = 0;
            return n;
        }
        finally {
            Closeables.close((Closeable)indexWriter, (boolean)false);
            Closeables.close((Closeable)matrixWriter, (boolean)false);
        }
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new RowIdJob(), (String[])args);
    }
}

