/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.similarity.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import javax.sql.DataSource;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.common.jdbc.AbstractJDBCComponent;
import org.apache.mahout.cf.taste.impl.model.jdbc.ConnectionPoolDataSource;
import org.apache.mahout.cf.taste.similarity.ItemSimilarity;
import org.apache.mahout.common.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJDBCItemSimilarity
extends AbstractJDBCComponent
implements ItemSimilarity {
    private static final Logger log = LoggerFactory.getLogger(AbstractJDBCItemSimilarity.class);
    static final String DEFAULT_SIMILARITY_TABLE = "taste_item_similarity";
    static final String DEFAULT_ITEM_A_ID_COLUMN = "item_id_a";
    static final String DEFAULT_ITEM_B_ID_COLUMN = "item_id_b";
    static final String DEFAULT_SIMILARITY_COLUMN = "similarity";
    private final DataSource dataSource;
    private final String similarityTable;
    private final String itemAIDColumn;
    private final String itemBIDColumn;
    private final String similarityColumn;
    private final String getItemItemSimilaritySQL;
    private final String getAllSimilarItemIDsSQL;

    protected AbstractJDBCItemSimilarity(DataSource dataSource, String getItemItemSimilaritySQL, String getAllSimilarItemIDsSQL) {
        this(dataSource, DEFAULT_SIMILARITY_TABLE, DEFAULT_ITEM_A_ID_COLUMN, DEFAULT_ITEM_B_ID_COLUMN, DEFAULT_SIMILARITY_COLUMN, getItemItemSimilaritySQL, getAllSimilarItemIDsSQL);
    }

    protected AbstractJDBCItemSimilarity(DataSource dataSource, String similarityTable, String itemAIDColumn, String itemBIDColumn, String similarityColumn, String getItemItemSimilaritySQL, String getAllSimilarItemIDsSQL) {
        AbstractJDBCComponent.checkNotNullAndLog((String)"similarityTable", (Object)similarityTable);
        AbstractJDBCComponent.checkNotNullAndLog((String)"itemAIDColumn", (Object)itemAIDColumn);
        AbstractJDBCComponent.checkNotNullAndLog((String)"itemBIDColumn", (Object)itemBIDColumn);
        AbstractJDBCComponent.checkNotNullAndLog((String)"similarityColumn", (Object)similarityColumn);
        AbstractJDBCComponent.checkNotNullAndLog((String)"getItemItemSimilaritySQL", (Object)getItemItemSimilaritySQL);
        AbstractJDBCComponent.checkNotNullAndLog((String)"getAllSimilarItemIDsSQL", (Object)getAllSimilarItemIDsSQL);
        if (!(dataSource instanceof ConnectionPoolDataSource)) {
            log.warn("You are not using ConnectionPoolDataSource. Make sure your DataSource pools connections to the database itself, or database performance will be severely reduced.");
        }
        this.dataSource = dataSource;
        this.similarityTable = similarityTable;
        this.itemAIDColumn = itemAIDColumn;
        this.itemBIDColumn = itemBIDColumn;
        this.similarityColumn = similarityColumn;
        this.getItemItemSimilaritySQL = getItemItemSimilaritySQL;
        this.getAllSimilarItemIDsSQL = getAllSimilarItemIDsSQL;
    }

    protected String getSimilarityTable() {
        return this.similarityTable;
    }

    protected String getItemAIDColumn() {
        return this.itemAIDColumn;
    }

    protected String getItemBIDColumn() {
        return this.itemBIDColumn;
    }

    protected String getSimilarityColumn() {
        return this.similarityColumn;
    }

    public double itemSimilarity(long itemID1, long itemID2) throws TasteException {
        double d;
        if (itemID1 == itemID2) {
            return 1.0;
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(this.getItemItemSimilaritySQL, 1003, 1007);
            stmt.setFetchDirection(1000);
            stmt.setFetchSize(this.getFetchSize());
            d = this.doItemSimilarity(stmt, itemID1, itemID2);
        }
        catch (SQLException sqle) {
            try {
                log.warn("Exception while retrieving similarity", (Throwable)sqle);
                throw new TasteException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                IOUtils.quietClose(null, stmt, (Connection)conn);
                throw throwable;
            }
        }
        IOUtils.quietClose(null, (Statement)stmt, (Connection)conn);
        return d;
    }

    public double[] itemSimilarities(long itemID1, long[] itemID2s) throws TasteException {
        double[] result = new double[itemID2s.length];
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(this.getItemItemSimilaritySQL, 1003, 1007);
            stmt.setFetchDirection(1000);
            stmt.setFetchSize(this.getFetchSize());
            for (int i = 0; i < itemID2s.length; ++i) {
                result[i] = this.doItemSimilarity(stmt, itemID1, itemID2s[i]);
            }
        }
        catch (SQLException sqle) {
            try {
                log.warn("Exception while retrieving item similarities", (Throwable)sqle);
                throw new TasteException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                IOUtils.quietClose(null, stmt, (Connection)conn);
                throw throwable;
            }
        }
        IOUtils.quietClose(null, (Statement)stmt, (Connection)conn);
        return result;
    }

    public long[] allSimilarItemIDs(long itemID) throws TasteException {
        FastIDSet allSimilarItemIDs = new FastIDSet();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(this.getAllSimilarItemIDsSQL, 1003, 1007);
            stmt.setFetchDirection(1000);
            stmt.setFetchSize(this.getFetchSize());
            stmt.setLong(1, itemID);
            stmt.setLong(2, itemID);
            rs = stmt.executeQuery();
            while (rs.next()) {
                allSimilarItemIDs.add(rs.getLong(1));
                allSimilarItemIDs.add(rs.getLong(2));
            }
        }
        catch (SQLException sqle) {
            try {
                log.warn("Exception while retrieving all similar itemIDs", (Throwable)sqle);
                throw new TasteException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                IOUtils.quietClose(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        IOUtils.quietClose((ResultSet)rs, (Statement)stmt, (Connection)conn);
        allSimilarItemIDs.remove(itemID);
        return allSimilarItemIDs.toArray();
    }

    public void refresh(Collection<Refreshable> alreadyRefreshed) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double doItemSimilarity(PreparedStatement stmt, long itemID1, long itemID2) throws SQLException {
        if (itemID1 > itemID2) {
            long temp = itemID1;
            itemID1 = itemID2;
            itemID2 = temp;
        }
        stmt.setLong(1, itemID1);
        stmt.setLong(2, itemID2);
        log.debug("Executing SQL query: {}", (Object)this.getItemItemSimilaritySQL);
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery();
            double d = rs.next() ? rs.getDouble(1) : Double.NaN;
            return d;
        }
        finally {
            IOUtils.quietClose((ResultSet)rs);
        }
    }
}

