/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.conversion.meanshift;

import java.io.IOException;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.mahout.clustering.conversion.meanshift.InputMapper;
import org.apache.mahout.clustering.iterator.ClusterWritable;
import org.apache.mahout.common.CommandLineUtil;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InputDriver {
    private static final Logger log = LoggerFactory.getLogger(InputDriver.class);

    private InputDriver() {
    }

    public static void main(String[] args) throws IOException, InterruptedException, ClassNotFoundException {
        GroupBuilder gbuilder = new GroupBuilder();
        DefaultOption inputOpt = DefaultOptionCreator.inputOption().withRequired(false).create();
        DefaultOption outputOpt = DefaultOptionCreator.outputOption().withRequired(false).create();
        Option helpOpt = DefaultOptionCreator.helpOption();
        Group group = gbuilder.withName("Options").withOption((Option)inputOpt).withOption((Option)outputOpt).withOption(helpOpt).create();
        try {
            Parser parser = new Parser();
            parser.setGroup(group);
            CommandLine cmdLine = parser.parse(args);
            if (cmdLine.hasOption(helpOpt)) {
                CommandLineUtil.printHelp((Group)group);
                return;
            }
            Path input = new Path(cmdLine.getValue((Option)inputOpt, (Object)"testdata").toString());
            Path output = new Path(cmdLine.getValue((Option)outputOpt, (Object)"output").toString());
            InputDriver.runJob(input, output);
        }
        catch (OptionException e) {
            log.error("Exception parsing command line: ", (Throwable)e);
            CommandLineUtil.printHelp((Group)group);
        }
    }

    public static void runJob(Path input, Path output) throws IOException, InterruptedException, ClassNotFoundException {
        Configuration conf = new Configuration();
        Job job = new Job(conf, "Mean Shift Input Driver running over input: " + input);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(ClusterWritable.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setMapperClass(InputMapper.class);
        job.setReducerClass(Reducer.class);
        job.setNumReduceTasks(0);
        job.setJarByClass(InputDriver.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{input});
        FileOutputFormat.setOutputPath((Job)job, (Path)output);
        boolean succeeded = job.waitForCompletion(true);
        if (!succeeded) {
            throw new IllegalStateException("Job failed!");
        }
    }
}

