/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.text;

import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli2.Option;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.apache.mahout.text.PrefixAdditionFilter;
import org.apache.mahout.text.SequenceFilesFromDirectoryFilter;
import org.apache.mahout.utils.io.ChunkedWriter;

public class SequenceFilesFromDirectory
extends AbstractJob {
    private static final String PREFIX_ADDITION_FILTER = PrefixAdditionFilter.class.getName();
    private static final String[] CHUNK_SIZE_OPTION = new String[]{"chunkSize", "chunk"};
    private static final String[] FILE_FILTER_CLASS_OPTION = new String[]{"fileFilterClass", "filter"};
    private static final String[] KEY_PREFIX_OPTION = new String[]{"keyPrefix", "prefix"};
    private static final String[] CHARSET_OPTION = new String[]{"charset", "c"};

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new SequenceFilesFromDirectory(), (String[])args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        this.addOptions();
        if (this.parseArguments(args) == null) {
            return -1;
        }
        Map<String, String> options = this.parseOptions();
        Path input = this.getInputPath();
        Path output = this.getOutputPath();
        if (this.hasOption("overwrite")) {
            Configuration conf = new Configuration();
            HadoopUtil.delete((Configuration)conf, (Path[])new Path[]{output});
        }
        String keyPrefix = this.getOption(KEY_PREFIX_OPTION[0]);
        Charset charset = Charset.forName(this.getOption(CHARSET_OPTION[0]));
        Configuration conf = this.getConf();
        FileSystem fs = FileSystem.get((URI)input.toUri(), (Configuration)conf);
        ChunkedWriter writer = new ChunkedWriter(conf, Integer.parseInt(options.get(CHUNK_SIZE_OPTION[0])), output);
        try {
            SequenceFilesFromDirectoryFilter pathFilter;
            String fileFilterClassName = options.get(FILE_FILTER_CLASS_OPTION[0]);
            if (PrefixAdditionFilter.class.getName().equals(fileFilterClassName)) {
                pathFilter = new PrefixAdditionFilter(conf, keyPrefix, options, writer, charset, fs);
            } else {
                Class<SequenceFilesFromDirectoryFilter> pathFilterClass = Class.forName(fileFilterClassName).asSubclass(SequenceFilesFromDirectoryFilter.class);
                Constructor<SequenceFilesFromDirectoryFilter> constructor = pathFilterClass.getConstructor(Configuration.class, String.class, Map.class, ChunkedWriter.class, Charset.class, FileSystem.class);
                pathFilter = constructor.newInstance(conf, keyPrefix, options, writer, fs);
            }
            fs.listStatus(input, (PathFilter)pathFilter);
        }
        finally {
            Closeables.closeQuietly((Closeable)writer);
        }
        return 0;
    }

    protected void addOptions() {
        this.addInputOption();
        this.addOutputOption();
        this.addOption((Option)DefaultOptionCreator.overwriteOption().create());
        this.addOption(CHUNK_SIZE_OPTION[0], CHUNK_SIZE_OPTION[1], "The chunkSize in MegaBytes. Defaults to 64", "64");
        this.addOption(FILE_FILTER_CLASS_OPTION[0], FILE_FILTER_CLASS_OPTION[1], "The name of the class to use for file parsing. Default: " + PREFIX_ADDITION_FILTER, PREFIX_ADDITION_FILTER);
        this.addOption(KEY_PREFIX_OPTION[0], KEY_PREFIX_OPTION[1], "The prefix to be prepended to the key", "");
        this.addOption(CHARSET_OPTION[0], CHARSET_OPTION[1], "The name of the character encoding of the input files. Default to UTF-8", "UTF-8");
    }

    protected Map<String, String> parseOptions() {
        HashMap options = Maps.newHashMap();
        options.put(CHUNK_SIZE_OPTION[0], this.getOption(CHUNK_SIZE_OPTION[0]));
        options.put(FILE_FILTER_CLASS_OPTION[0], this.getOption(FILE_FILTER_CLASS_OPTION[0]));
        options.put(CHARSET_OPTION[0], this.getOption(CHARSET_OPTION[0]));
        return options;
    }
}

