/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.vectors.lucene;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import java.io.IOException;
import java.util.Collections;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.SetBasedFieldSelector;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermVectorMapper;
import org.apache.mahout.math.NamedVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.utils.Bump125;
import org.apache.mahout.utils.vectors.lucene.VectorMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LuceneIterator
extends AbstractIterator<Vector> {
    private static final Logger log = LoggerFactory.getLogger(LuceneIterator.class);
    private final IndexReader indexReader;
    private final String field;
    private final String idField;
    private final FieldSelector idFieldSelector;
    private final VectorMapper mapper;
    private final double normPower;
    private final TermDocs termDocs;
    private int numErrorDocs = 0;
    private int maxErrorDocs = 0;
    private final Bump125 bump = new Bump125();
    private long nextLogRecord = this.bump.increment();
    private int skippedErrorMessages = 0;

    public LuceneIterator(IndexReader indexReader, String idField, String field, VectorMapper mapper, double normPower) throws IOException {
        this(indexReader, idField, field, mapper, normPower, 0.0);
    }

    public LuceneIterator(IndexReader indexReader, String idField, String field, VectorMapper mapper, double normPower, double maxPercentErrorDocs) throws IOException {
        Preconditions.checkArgument((normPower == -1.0 || normPower >= 0.0 ? 1 : 0) != 0, (String)"If specified normPower must be nonnegative", (Object[])new Object[]{normPower});
        Preconditions.checkArgument((maxPercentErrorDocs >= 0.0 && maxPercentErrorDocs <= 1.0 ? 1 : 0) != 0);
        this.idFieldSelector = new SetBasedFieldSelector(Collections.singleton(idField), Collections.emptySet());
        this.indexReader = indexReader;
        this.idField = idField;
        this.field = field;
        this.mapper = mapper;
        this.normPower = normPower;
        this.termDocs = indexReader.termDocs(null);
        this.maxErrorDocs = (int)(maxPercentErrorDocs * (double)indexReader.numDocs());
    }

    protected Vector computeNext() {
        try {
            if (!this.termDocs.next()) {
                return (Vector)this.endOfData();
            }
            int doc = this.termDocs.doc();
            TermFreqVector termFreqVector = this.indexReader.getTermFreqVector(doc, this.field);
            if (termFreqVector == null) {
                ++this.numErrorDocs;
                if (this.numErrorDocs >= this.maxErrorDocs) {
                    log.error("There are too many documents that do not have a term vector for {}", (Object)this.field);
                    throw new IllegalStateException("There are too many documents that do not have a term vector for " + this.field);
                }
                if ((long)this.numErrorDocs >= this.nextLogRecord) {
                    if (this.skippedErrorMessages == 0) {
                        log.warn("{} does not have a term vector for {}", (Object)this.indexReader.document(doc).get(this.idField), (Object)this.field);
                    } else {
                        log.warn("{} documents do not have a term vector for {}", (Object)this.numErrorDocs, (Object)this.field);
                    }
                    this.nextLogRecord = this.bump.increment();
                    this.skippedErrorMessages = 0;
                } else {
                    ++this.skippedErrorMessages;
                }
                this.computeNext();
            }
            this.indexReader.getTermFreqVector(doc, this.field, (TermVectorMapper)this.mapper);
            this.mapper.setDocumentNumber(doc);
            Vector result = this.mapper.getVector();
            if (result == null) {
                return null;
            }
            String name = this.idField != null ? this.indexReader.document(doc, this.idFieldSelector).get(this.idField) : String.valueOf(doc);
            result = this.normPower == -1.0 ? new NamedVector(result, name) : new NamedVector(result.normalize(this.normPower), name);
            return result;
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }
}

