/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo3d;

import org.apache.lucene.geo3d.GeoBBox;
import org.apache.lucene.geo3d.GeoBaseMembershipShape;
import org.apache.lucene.geo3d.GeoPoint;
import org.apache.lucene.geo3d.GeoShape;
import org.apache.lucene.geo3d.PlanetModel;

public abstract class GeoBaseBBox
extends GeoBaseMembershipShape
implements GeoBBox {
    protected static final int ALL_INSIDE = 0;
    protected static final int SOME_INSIDE = 1;
    protected static final int NONE_INSIDE = 2;

    public GeoBaseBBox(PlanetModel planetModel) {
        super(planetModel);
    }

    protected int isShapeInsideBBox(GeoShape path) {
        GeoPoint[] pathPoints = path.getEdgePoints();
        boolean foundOutside = false;
        boolean foundInside = false;
        for (GeoPoint p : pathPoints) {
            if (this.isWithin(p)) {
                foundInside = true;
            } else {
                foundOutside = true;
            }
            if (!foundInside || !foundOutside) continue;
            return 1;
        }
        if (!foundInside && !foundOutside) {
            return 2;
        }
        if (foundInside && !foundOutside) {
            return 0;
        }
        if (foundOutside && !foundInside) {
            return 2;
        }
        return 1;
    }
}

