/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.bkdtree3d;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.bkdtree3d.BKD3DTreeWriter;
import org.apache.lucene.bkdtree3d.Geo3DDocValuesFormat;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.geo3d.PlanetModel;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;

@Deprecated
class Geo3DDocValuesConsumer
extends DocValuesConsumer
implements Closeable {
    final DocValuesConsumer delegate;
    final int maxPointsInLeafNode;
    final int maxPointsSortInHeap;
    final IndexOutput out;
    final Map<Integer, Long> fieldIndexFPs = new HashMap<Integer, Long>();
    final SegmentWriteState state;

    public Geo3DDocValuesConsumer(PlanetModel planetModel, DocValuesConsumer delegate, SegmentWriteState state, int maxPointsInLeafNode, int maxPointsSortInHeap) throws IOException {
        BKD3DTreeWriter.verifyParams(maxPointsInLeafNode, maxPointsSortInHeap);
        this.delegate = delegate;
        this.maxPointsInLeafNode = maxPointsInLeafNode;
        this.maxPointsSortInHeap = maxPointsSortInHeap;
        this.state = state;
        String datFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"g3dd");
        this.out = state.directory.createOutput(datFileName, state.context);
        CodecUtil.writeIndexHeader((DataOutput)this.out, (String)"Geo3DData", (int)0, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
        this.out.writeLong(Double.doubleToLongBits(planetModel.getMaximumMagnitude()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        block12: {
            IndexOutput metaOut;
            block10: {
                boolean success;
                block11: {
                    block9: {
                        success = false;
                        try {
                            CodecUtil.writeFooter((IndexOutput)this.out);
                            success = true;
                            if (!success) break block9;
                        }
                        catch (Throwable throwable) {
                            if (success) {
                                IOUtils.close((Closeable[])new Closeable[]{this.delegate, this.out});
                            } else {
                                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.delegate, this.out});
                            }
                            throw throwable;
                        }
                        IOUtils.close((Closeable[])new Closeable[]{this.delegate, this.out});
                        break block11;
                    }
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.delegate, this.out});
                }
                String metaFileName = IndexFileNames.segmentFileName((String)this.state.segmentInfo.name, (String)this.state.segmentSuffix, (String)"g3dm");
                metaOut = this.state.directory.createOutput(metaFileName, this.state.context);
                success = false;
                try {
                    CodecUtil.writeIndexHeader((DataOutput)metaOut, (String)"Geo3DMeta", (int)0, (byte[])this.state.segmentInfo.getId(), (String)this.state.segmentSuffix);
                    metaOut.writeVInt(this.fieldIndexFPs.size());
                    for (Map.Entry<Integer, Long> ent : this.fieldIndexFPs.entrySet()) {
                        metaOut.writeVInt(ent.getKey().intValue());
                        metaOut.writeVLong(ent.getValue().longValue());
                    }
                    CodecUtil.writeFooter((IndexOutput)metaOut);
                    success = true;
                    if (!success) break block10;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{metaOut});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{metaOut});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{metaOut});
                break block12;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{metaOut});
        }
    }

    public void addSortedNumericField(FieldInfo field, Iterable<Number> docToValueCount, Iterable<Number> values) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void addNumericField(FieldInfo field, Iterable<Number> values) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void addBinaryField(FieldInfo field, Iterable<BytesRef> values) throws IOException {
        this.delegate.addBinaryField(field, values);
        BKD3DTreeWriter writer = new BKD3DTreeWriter(this.maxPointsInLeafNode, this.maxPointsSortInHeap);
        Iterator<BytesRef> valuesIt = values.iterator();
        for (int docID = 0; docID < this.state.segmentInfo.maxDoc(); ++docID) {
            assert (valuesIt.hasNext());
            BytesRef value = valuesIt.next();
            if (value == null) continue;
            assert (value.length == 12);
            int x = Geo3DDocValuesFormat.readInt(value.bytes, value.offset);
            int y = Geo3DDocValuesFormat.readInt(value.bytes, value.offset + 4);
            int z = Geo3DDocValuesFormat.readInt(value.bytes, value.offset + 8);
            writer.add(x, y, z, docID);
        }
        long indexStartFP = writer.finish(this.out);
        this.fieldIndexFPs.put(field.number, indexStartFP);
    }

    public void addSortedField(FieldInfo field, Iterable<BytesRef> values, Iterable<Number> docToOrd) {
        throw new UnsupportedOperationException();
    }

    public void addSortedSetField(FieldInfo field, Iterable<BytesRef> values, Iterable<Number> docToOrdCount, Iterable<Number> ords) {
        throw new UnsupportedOperationException();
    }
}

