/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.util;

import com.spatial4j.core.shape.Shape;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.BoolDocValues;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.spatial.query.SpatialOperation;

public class ShapePredicateValueSource
extends ValueSource {
    private final ValueSource shapeValuesource;
    private final SpatialOperation op;
    private final Shape queryShape;

    public ShapePredicateValueSource(ValueSource shapeValuesource, SpatialOperation op, Shape queryShape) {
        this.shapeValuesource = shapeValuesource;
        this.op = op;
        this.queryShape = queryShape;
    }

    public String description() {
        return this.shapeValuesource + " " + this.op + " " + this.queryShape;
    }

    public void createWeight(Map context, IndexSearcher searcher) throws IOException {
        this.shapeValuesource.createWeight(context, searcher);
    }

    public FunctionValues getValues(Map context, AtomicReaderContext readerContext) throws IOException {
        final FunctionValues shapeValues = this.shapeValuesource.getValues(context, readerContext);
        return new BoolDocValues(this){

            public boolean boolVal(int doc) {
                Shape indexedShape = (Shape)shapeValues.objectVal(doc);
                if (indexedShape == null) {
                    return false;
                }
                return ShapePredicateValueSource.this.op.evaluate(indexedShape, ShapePredicateValueSource.this.queryShape);
            }

            public Explanation explain(int doc) {
                Explanation exp = super.explain(doc);
                exp.addDetail(shapeValues.explain(doc));
                return exp;
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ShapePredicateValueSource that = (ShapePredicateValueSource)((Object)o);
        if (!this.shapeValuesource.equals((Object)that.shapeValuesource)) {
            return false;
        }
        if (!this.op.equals(that.op)) {
            return false;
        }
        return this.queryShape.equals((Object)that.queryShape);
    }

    public int hashCode() {
        int result = this.shapeValuesource.hashCode();
        result = 31 * result + this.op.hashCode();
        result = 31 * result + this.queryShape.hashCode();
        return result;
    }
}

