/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.bbox;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.spatial.ShapeValues;
import org.apache.lucene.spatial.ShapeValuesSource;
import org.locationtech.spatial4j.shape.Rectangle;

public abstract class BBoxSimilarityValueSource
extends DoubleValuesSource {
    private final ShapeValuesSource bboxValueSource;

    public BBoxSimilarityValueSource(ShapeValuesSource bboxValueSource) {
        this.bboxValueSource = bboxValueSource;
    }

    public DoubleValuesSource rewrite(IndexSearcher searcher) throws IOException {
        return this;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(" + this.bboxValueSource.toString() + "," + this.similarityDescription() + ")";
    }

    protected abstract String similarityDescription();

    public DoubleValues getValues(LeafReaderContext readerContext, DoubleValues scores) throws IOException {
        final ShapeValues shapeValues = this.bboxValueSource.getValues(readerContext);
        return DoubleValues.withDefault((DoubleValues)new DoubleValues(){

            public double doubleValue() throws IOException {
                return BBoxSimilarityValueSource.this.score((Rectangle)shapeValues.value(), null);
            }

            public boolean advanceExact(int doc) throws IOException {
                return shapeValues.advanceExact(doc);
            }
        }, (double)0.0);
    }

    protected abstract double score(Rectangle var1, AtomicReference<Explanation> var2);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        BBoxSimilarityValueSource that = (BBoxSimilarityValueSource)((Object)o);
        return this.bboxValueSource.equals(that.bboxValueSource);
    }

    public int hashCode() {
        return this.bboxValueSource.hashCode();
    }

    public Explanation explain(LeafReaderContext ctx, int docId, Explanation scoreExplanation) throws IOException {
        DoubleValues dv = this.getValues(ctx, DoubleValuesSource.constant((double)scoreExplanation.getValue()).getValues(ctx, null));
        if (dv.advanceExact(docId)) {
            AtomicReference<Explanation> explanation = new AtomicReference<Explanation>();
            ShapeValues shapeValues = this.bboxValueSource.getValues(ctx);
            if (shapeValues.advanceExact(docId)) {
                this.score((Rectangle)shapeValues.value(), explanation);
                return explanation.get();
            }
        }
        return Explanation.noMatch((String)this.toString(), (Explanation[])new Explanation[0]);
    }

    public boolean isCacheable(LeafReaderContext ctx) {
        return this.bboxValueSource.isCacheable(ctx);
    }

    public boolean needsScores() {
        return false;
    }
}

