/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.intervals;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.MatchesIterator;
import org.apache.lucene.search.intervals.IntervalIterator;
import org.apache.lucene.search.intervals.IntervalMatches;
import org.apache.lucene.search.intervals.IntervalsSource;

class OffsetIntervalsSource
extends IntervalsSource {
    private final IntervalsSource in;
    private final boolean before;

    OffsetIntervalsSource(IntervalsSource in, boolean before) {
        this.in = in;
        this.before = before;
    }

    @Override
    public IntervalIterator intervals(String field, LeafReaderContext ctx) throws IOException {
        IntervalIterator it = this.in.intervals(field, ctx);
        if (it == null) {
            return null;
        }
        return this.offset(it);
    }

    private IntervalIterator offset(IntervalIterator it) {
        if (this.before) {
            return new OffsetIntervalIterator(it){

                @Override
                public int start() {
                    int pos = this.in.start();
                    if (pos == -1) {
                        return -1;
                    }
                    if (pos == Integer.MAX_VALUE) {
                        return Integer.MAX_VALUE;
                    }
                    return Math.max(0, pos - 1);
                }
            };
        }
        return new OffsetIntervalIterator(it){

            @Override
            public int start() {
                int pos = this.in.end() + 1;
                if (pos == 0) {
                    return -1;
                }
                if (pos < 0) {
                    return Integer.MAX_VALUE;
                }
                if (pos == Integer.MAX_VALUE) {
                    return 0x7FFFFFFE;
                }
                return pos;
            }
        };
    }

    @Override
    public MatchesIterator matches(String field, LeafReaderContext ctx, int doc) throws IOException {
        MatchesIterator mi = this.in.matches(field, ctx, doc);
        if (mi == null) {
            return null;
        }
        return IntervalMatches.asMatches(this.offset(IntervalMatches.wrapMatches(mi, doc)), mi, doc);
    }

    @Override
    public void extractTerms(String field, Set<Term> terms) {
        this.in.extractTerms(field, terms);
    }

    @Override
    public int minExtent() {
        return 1;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OffsetIntervalsSource that = (OffsetIntervalsSource)o;
        return this.before == that.before && Objects.equals(this.in, that.in);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.in, this.before);
    }

    @Override
    public String toString() {
        if (this.before) {
            return "PRECEDING(" + this.in + ")";
        }
        return "FOLLOWING(" + this.in + ")";
    }

    private static abstract class OffsetIntervalIterator
    extends IntervalIterator {
        final IntervalIterator in;

        OffsetIntervalIterator(IntervalIterator in) {
            this.in = in;
        }

        @Override
        public int end() {
            return this.start();
        }

        @Override
        public int gaps() {
            return 0;
        }

        @Override
        public int nextInterval() throws IOException {
            this.in.nextInterval();
            return this.start();
        }

        @Override
        public float matchCost() {
            return this.in.matchCost();
        }

        public int docID() {
            return this.in.docID();
        }

        public int nextDoc() throws IOException {
            return this.in.nextDoc();
        }

        public int advance(int target) throws IOException {
            return this.in.advance(target);
        }

        public long cost() {
            return this.in.cost();
        }
    }
}

