/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.intervals;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.search.intervals.ConjunctionIntervalIterator;
import org.apache.lucene.search.intervals.IntervalIterator;
import org.apache.lucene.util.PriorityQueue;

abstract class IntervalFunction {
    static final IntervalFunction BLOCK = new SingletonFunction("BLOCK"){

        @Override
        public IntervalIterator apply(List<IntervalIterator> iterators) {
            return new BlockIntervalIterator(iterators);
        }
    };
    static final IntervalFunction ORDERED = new SingletonFunction("ORDERED"){

        @Override
        public IntervalIterator apply(List<IntervalIterator> intervalIterators) {
            return new OrderedIntervalIterator(intervalIterators);
        }
    };
    static final IntervalFunction UNORDERED = new SingletonFunction("UNORDERED"){

        @Override
        public IntervalIterator apply(List<IntervalIterator> intervalIterators) {
            return new UnorderedIntervalIterator(intervalIterators, true);
        }
    };
    static final IntervalFunction UNORDERED_NO_OVERLAP = new SingletonFunction("UNORDERED_NO_OVERLAP"){

        @Override
        public IntervalIterator apply(List<IntervalIterator> iterators) {
            return new UnorderedIntervalIterator(iterators, false);
        }
    };
    static final IntervalFunction CONTAINING = new SingletonFunction("CONTAINING"){

        @Override
        public IntervalIterator apply(List<IntervalIterator> iterators) {
            if (iterators.size() != 2) {
                throw new IllegalStateException("CONTAINING function requires two iterators");
            }
            IntervalIterator a = iterators.get(0);
            IntervalIterator b = iterators.get(1);
            return new FilteringIntervalIterator(a, b){

                @Override
                public int nextInterval() throws IOException {
                    if (!this.bpos) {
                        return Integer.MAX_VALUE;
                    }
                    while (this.a.nextInterval() != Integer.MAX_VALUE) {
                        while (this.b.start() < this.a.start() && this.b.end() < this.a.end()) {
                            if (this.b.nextInterval() != Integer.MAX_VALUE) continue;
                            return Integer.MAX_VALUE;
                        }
                        if (this.a.start() > this.b.start() || this.a.end() < this.b.end()) continue;
                        return this.a.start();
                    }
                    return Integer.MAX_VALUE;
                }
            };
        }
    };
    static final IntervalFunction CONTAINED_BY = new SingletonFunction("CONTAINED_BY"){

        @Override
        public IntervalIterator apply(List<IntervalIterator> iterators) {
            if (iterators.size() != 2) {
                throw new IllegalStateException("CONTAINED_BY function requires two iterators");
            }
            IntervalIterator a = iterators.get(0);
            IntervalIterator b = iterators.get(1);
            return new FilteringIntervalIterator(a, b){

                @Override
                public int nextInterval() throws IOException {
                    if (!this.bpos) {
                        return Integer.MAX_VALUE;
                    }
                    while (this.a.nextInterval() != Integer.MAX_VALUE) {
                        while (this.b.end() < this.a.end()) {
                            if (this.b.nextInterval() != Integer.MAX_VALUE) continue;
                            this.bpos = false;
                            return Integer.MAX_VALUE;
                        }
                        if (this.b.start() > this.a.start()) continue;
                        return this.a.start();
                    }
                    this.bpos = false;
                    return Integer.MAX_VALUE;
                }
            };
        }
    };
    static final IntervalFunction OVERLAPPING = new SingletonFunction("OVERLAPPING"){

        @Override
        public IntervalIterator apply(List<IntervalIterator> iterators) {
            if (iterators.size() != 2) {
                throw new IllegalStateException("OVERLAPPING function requires two iterators");
            }
            IntervalIterator a = iterators.get(0);
            IntervalIterator b = iterators.get(1);
            return new FilteringIntervalIterator(a, b){

                @Override
                public int nextInterval() throws IOException {
                    if (!this.bpos) {
                        return Integer.MAX_VALUE;
                    }
                    while (this.a.nextInterval() != Integer.MAX_VALUE) {
                        while (this.b.end() < this.a.start()) {
                            if (this.b.nextInterval() != Integer.MAX_VALUE) continue;
                            this.bpos = false;
                            return Integer.MAX_VALUE;
                        }
                        if (this.b.start() > this.a.end()) continue;
                        return this.a.start();
                    }
                    this.bpos = false;
                    return Integer.MAX_VALUE;
                }
            };
        }
    };

    IntervalFunction() {
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract String toString();

    public abstract IntervalIterator apply(List<IntervalIterator> var1);

    private static abstract class SingletonFunction
    extends IntervalFunction {
        private final String name;

        protected SingletonFunction(String name) {
            this.name = name;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    private static abstract class FilteringIntervalIterator
    extends ConjunctionIntervalIterator {
        final IntervalIterator a;
        final IntervalIterator b;
        boolean bpos;

        protected FilteringIntervalIterator(IntervalIterator a, IntervalIterator b) {
            super(Arrays.asList(a, b));
            this.a = a;
            this.b = b;
        }

        @Override
        public int start() {
            if (!this.bpos) {
                return Integer.MAX_VALUE;
            }
            return this.a.start();
        }

        @Override
        public int end() {
            if (!this.bpos) {
                return Integer.MAX_VALUE;
            }
            return this.a.end();
        }

        @Override
        public int gaps() {
            return this.a.gaps();
        }

        @Override
        protected void reset() throws IOException {
            this.bpos = this.b.nextInterval() != Integer.MAX_VALUE;
        }
    }

    private static class UnorderedIntervalIterator
    extends ConjunctionIntervalIterator {
        private final PriorityQueue<IntervalIterator> queue;
        private final IntervalIterator[] subIterators;
        private final int[] innerPositions;
        private final boolean allowOverlaps;
        int start = -1;
        int end = -1;
        int firstEnd;
        int queueEnd;

        UnorderedIntervalIterator(List<IntervalIterator> subIterators, boolean allowOverlaps) {
            super(subIterators);
            this.queue = new PriorityQueue<IntervalIterator>(subIterators.size()){

                protected boolean lessThan(IntervalIterator a, IntervalIterator b) {
                    return a.start() < b.start() || a.start() == b.start() && a.end() >= b.end();
                }
            };
            this.subIterators = new IntervalIterator[subIterators.size()];
            this.innerPositions = new int[subIterators.size() * 2];
            this.allowOverlaps = allowOverlaps;
            for (int i = 0; i < subIterators.size(); ++i) {
                this.subIterators[i] = subIterators.get(i);
            }
        }

        @Override
        public int start() {
            return this.start;
        }

        @Override
        public int end() {
            return this.end;
        }

        void updateRightExtreme(IntervalIterator it) {
            int itEnd = it.end();
            if (itEnd > this.queueEnd) {
                this.queueEnd = itEnd;
            }
        }

        @Override
        public int nextInterval() throws IOException {
            IntervalIterator it;
            while (this.queue.size() == this.subIterators.length && ((IntervalIterator)((Object)this.queue.top())).start() == this.start) {
                it = (IntervalIterator)((Object)this.queue.pop());
                if (it == null || it.nextInterval() == Integer.MAX_VALUE) continue;
                if (!this.allowOverlaps) {
                    while (this.hasOverlaps(it)) {
                        if (it.nextInterval() != Integer.MAX_VALUE) continue;
                        this.end = Integer.MAX_VALUE;
                        this.start = Integer.MAX_VALUE;
                        return Integer.MAX_VALUE;
                    }
                }
                this.queue.add((Object)it);
                this.updateRightExtreme(it);
            }
            if (this.queue.size() < this.subIterators.length) {
                this.end = Integer.MAX_VALUE;
                this.start = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            do {
                this.start = ((IntervalIterator)((Object)this.queue.top())).start();
                this.firstEnd = ((IntervalIterator)((Object)this.queue.top())).end();
                this.end = this.queueEnd;
                if (((IntervalIterator)((Object)this.queue.top())).end() == this.end) {
                    return this.start;
                }
                it = (IntervalIterator)((Object)this.queue.pop());
                if (it == null || it.nextInterval() == Integer.MAX_VALUE) continue;
                if (!this.allowOverlaps) {
                    while (this.hasOverlaps(it)) {
                        if (it.nextInterval() != Integer.MAX_VALUE) continue;
                        return this.start;
                    }
                }
                this.queue.add((Object)it);
                this.updateRightExtreme(it);
            } while (this.queue.size() == this.subIterators.length && this.end == this.queueEnd);
            return this.start;
        }

        @Override
        public int gaps() {
            for (int i = 0; i < this.subIterators.length; ++i) {
                if (this.subIterators[i].end() > this.end) {
                    this.innerPositions[i * 2] = this.start;
                    this.innerPositions[i * 2 + 1] = this.firstEnd;
                    continue;
                }
                this.innerPositions[i * 2] = this.subIterators[i].start();
                this.innerPositions[i * 2 + 1] = this.subIterators[i].end();
            }
            Arrays.sort(this.innerPositions);
            int gaps = 0;
            for (int i = 1; i < this.subIterators.length; ++i) {
                gaps += this.innerPositions[i * 2] - this.innerPositions[i * 2 - 1] - 1;
            }
            return gaps;
        }

        @Override
        protected void reset() throws IOException {
            this.end = -1;
            this.start = -1;
            this.queueEnd = -1;
            this.queue.clear();
            block0: for (IntervalIterator it : this.subIterators) {
                if (it.nextInterval() == Integer.MAX_VALUE) break;
                if (!this.allowOverlaps) {
                    while (this.hasOverlaps(it)) {
                        if (it.nextInterval() != Integer.MAX_VALUE) continue;
                        break block0;
                    }
                }
                this.queue.add((Object)it);
                this.updateRightExtreme(it);
            }
        }

        private boolean hasOverlaps(IntervalIterator candidate) {
            for (IntervalIterator it : this.queue) {
                if (it.start() < candidate.start()) {
                    if (it.end() < candidate.start()) continue;
                    return true;
                }
                if (it.start() == candidate.start()) {
                    return true;
                }
                if (it.start() > candidate.end()) continue;
                return true;
            }
            return false;
        }
    }

    private static class OrderedIntervalIterator
    extends ConjunctionIntervalIterator {
        int start = -1;
        int end = -1;
        int i;
        int firstEnd;

        private OrderedIntervalIterator(List<IntervalIterator> subIntervals) {
            super(subIntervals);
        }

        @Override
        public int start() {
            return this.start;
        }

        @Override
        public int end() {
            return this.end;
        }

        @Override
        public int nextInterval() throws IOException {
            this.end = Integer.MAX_VALUE;
            this.start = Integer.MAX_VALUE;
            int b = Integer.MAX_VALUE;
            this.i = 1;
            while (true) {
                if (((IntervalIterator)((Object)this.subIterators.get(this.i - 1))).end() >= b) {
                    return this.start;
                }
                if (this.i != this.subIterators.size() && ((IntervalIterator)((Object)this.subIterators.get(this.i))).start() <= ((IntervalIterator)((Object)this.subIterators.get(this.i - 1))).end()) {
                    do {
                        if (((IntervalIterator)((Object)this.subIterators.get(this.i))).end() < b && ((IntervalIterator)((Object)this.subIterators.get(this.i))).nextInterval() != Integer.MAX_VALUE) continue;
                        return this.start;
                    } while (((IntervalIterator)((Object)this.subIterators.get(this.i))).start() <= ((IntervalIterator)((Object)this.subIterators.get(this.i - 1))).end());
                    ++this.i;
                    continue;
                }
                this.start = ((IntervalIterator)((Object)this.subIterators.get(0))).start();
                if (this.start == Integer.MAX_VALUE) {
                    this.end = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                this.firstEnd = ((IntervalIterator)((Object)this.subIterators.get(0))).end();
                this.end = ((IntervalIterator)((Object)this.subIterators.get(this.subIterators.size() - 1))).end();
                b = ((IntervalIterator)((Object)this.subIterators.get(this.subIterators.size() - 1))).start();
                this.i = 1;
                if (((IntervalIterator)((Object)this.subIterators.get(0))).nextInterval() == Integer.MAX_VALUE) break;
            }
            return this.start;
        }

        @Override
        public int gaps() {
            int gaps = ((IntervalIterator)((Object)this.subIterators.get(1))).start() - this.firstEnd - 1;
            for (int i = 2; i < this.subIterators.size(); ++i) {
                gaps += ((IntervalIterator)((Object)this.subIterators.get(i))).start() - ((IntervalIterator)((Object)this.subIterators.get(i - 1))).end() - 1;
            }
            return gaps;
        }

        @Override
        protected void reset() throws IOException {
            ((IntervalIterator)((Object)this.subIterators.get(0))).nextInterval();
            this.i = 1;
            this.firstEnd = -1;
            this.end = -1;
            this.start = -1;
        }
    }

    private static class BlockIntervalIterator
    extends ConjunctionIntervalIterator {
        int start = -1;
        int end = -1;

        BlockIntervalIterator(List<IntervalIterator> subIterators) {
            super(subIterators);
        }

        @Override
        public int start() {
            return this.start;
        }

        @Override
        public int end() {
            return this.end;
        }

        @Override
        public int gaps() {
            return 0;
        }

        @Override
        public int nextInterval() throws IOException {
            if (((IntervalIterator)((Object)this.subIterators.get(0))).nextInterval() == Integer.MAX_VALUE) {
                this.end = Integer.MAX_VALUE;
                this.start = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            int i = 1;
            while (i < this.subIterators.size()) {
                while (((IntervalIterator)((Object)this.subIterators.get(i))).start() <= ((IntervalIterator)((Object)this.subIterators.get(i - 1))).end()) {
                    if (((IntervalIterator)((Object)this.subIterators.get(i))).nextInterval() != Integer.MAX_VALUE) continue;
                    this.end = Integer.MAX_VALUE;
                    this.start = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                if (((IntervalIterator)((Object)this.subIterators.get(i))).start() == ((IntervalIterator)((Object)this.subIterators.get(i - 1))).end() + 1) {
                    ++i;
                    continue;
                }
                if (((IntervalIterator)((Object)this.subIterators.get(0))).nextInterval() == Integer.MAX_VALUE) {
                    this.end = Integer.MAX_VALUE;
                    this.start = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                i = 1;
            }
            this.start = ((IntervalIterator)((Object)this.subIterators.get(0))).start();
            this.end = ((IntervalIterator)((Object)this.subIterators.get(this.subIterators.size() - 1))).end();
            return this.start;
        }

        @Override
        protected void reset() {
            this.end = -1;
            this.start = -1;
        }
    }
}

