/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.rangetree;

import java.io.IOException;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.rangetree.RangeTreeReader;
import org.apache.lucene.rangetree.RangeTreeSortedSetDocValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.ToStringUtils;

public class SortedSetRangeTreeQuery
extends Query {
    final String field;
    final BytesRef minValue;
    final BytesRef maxValue;
    final boolean minInclusive;
    final boolean maxInclusive;

    public SortedSetRangeTreeQuery(String field, BytesRef minValue, boolean minInclusive, BytesRef maxValue, boolean maxInclusive) {
        this.field = field;
        this.minInclusive = minInclusive;
        this.minValue = minValue;
        this.maxInclusive = maxInclusive;
        this.maxValue = maxValue;
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new ConstantScoreWeight(this){

            public Scorer scorer(LeafReaderContext context) throws IOException {
                long ord;
                long ord2;
                LeafReader reader = context.reader();
                final SortedSetDocValues ssdv = reader.getSortedSetDocValues(SortedSetRangeTreeQuery.this.field);
                if (ssdv == null) {
                    return null;
                }
                if (!(ssdv instanceof RangeTreeSortedSetDocValues)) {
                    throw new IllegalStateException("field \"" + SortedSetRangeTreeQuery.this.field + "\" was not indexed with RangeTreeDocValuesFormat: got: " + ssdv);
                }
                RangeTreeSortedSetDocValues treeDV = (RangeTreeSortedSetDocValues)ssdv;
                RangeTreeReader tree = treeDV.getRangeTreeReader();
                long minOrdIncl = SortedSetRangeTreeQuery.this.minValue == null ? 0L : ((ord2 = ssdv.lookupTerm(SortedSetRangeTreeQuery.this.minValue)) >= 0L ? (SortedSetRangeTreeQuery.this.minInclusive ? ord2 : ord2 + 1L) : -ord2 - 1L);
                long maxOrdIncl = SortedSetRangeTreeQuery.this.maxValue == null ? Long.MAX_VALUE : ((ord = ssdv.lookupTerm(SortedSetRangeTreeQuery.this.maxValue)) >= 0L ? (SortedSetRangeTreeQuery.this.maxInclusive ? ord : ord - 1L) : -ord - 2L);
                if (maxOrdIncl < minOrdIncl) {
                    return null;
                }
                SortedNumericDocValues ords = new SortedNumericDocValues(){
                    private long[] ords = new long[2];
                    private int count;

                    public void setDocument(int doc) {
                        long ord;
                        ssdv.setDocument(doc);
                        this.count = 0;
                        while ((ord = ssdv.nextOrd()) != -1L) {
                            if (this.count == this.ords.length) {
                                this.ords = ArrayUtil.grow((long[])this.ords, (int)(this.count + 1));
                            }
                            this.ords[this.count++] = ord;
                        }
                    }

                    public int count() {
                        return this.count;
                    }

                    public long valueAt(int index) {
                        return this.ords[index];
                    }
                };
                DocIdSet result = tree.intersect(minOrdIncl, maxOrdIncl, ords, context.reader().maxDoc());
                DocIdSetIterator disi = result.iterator();
                return new ConstantScoreScorer((Weight)this, this.score(), disi);
            }
        };
    }

    public int hashCode() {
        int hash = super.hashCode();
        if (this.minValue != null) {
            hash += this.minValue.hashCode() ^ 0x14FA55FB;
        }
        if (this.maxValue != null) {
            hash += this.maxValue.hashCode() ^ 0x733FA5FE;
        }
        return hash + (Boolean.valueOf(this.minInclusive).hashCode() ^ 0x14FA55FB) + (Boolean.valueOf(this.maxInclusive).hashCode() ^ 0x733FA5FE);
    }

    public boolean equals(Object other) {
        if (super.equals(other)) {
            SortedSetRangeTreeQuery q = (SortedSetRangeTreeQuery)((Object)other);
            return (q.minValue == null ? this.minValue == null : q.minValue.equals((Object)this.minValue)) && (q.maxValue == null ? this.maxValue == null : q.maxValue.equals((Object)this.maxValue)) && this.minInclusive == q.minInclusive && this.maxInclusive == q.maxInclusive;
        }
        return false;
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(((Object)((Object)this)).getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field)) {
            sb.append("field=");
            sb.append(this.field);
            sb.append(':');
        }
        return sb.append(this.minInclusive ? (char)'[' : '{').append(this.minValue == null ? "*" : this.minValue.toString()).append(" TO ").append(this.maxValue == null ? "*" : this.maxValue.toString()).append(this.maxInclusive ? (char)']' : '}').append(ToStringUtils.boost((float)this.getBoost())).toString();
    }
}

