/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public class FunctionQuery
extends Query {
    final ValueSource func;

    public FunctionQuery(ValueSource func) {
        this.func = func;
    }

    public ValueSource getValueSource() {
        return this.func;
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        return new FunctionWeight(searcher, boost);
    }

    public String toString(String field) {
        return this.func.toString();
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.func.equals(((FunctionQuery)((Object)other)).func);
    }

    public int hashCode() {
        return this.classHash() ^ this.func.hashCode();
    }

    protected class AllScorer
    extends Scorer {
        final IndexReader reader;
        final FunctionWeight weight;
        final int maxDoc;
        final float boost;
        final DocIdSetIterator iterator;
        final FunctionValues vals;

        public AllScorer(LeafReaderContext context, FunctionWeight w, float boost) throws IOException {
            super((Weight)w);
            this.weight = w;
            this.boost = boost;
            this.reader = context.reader();
            this.maxDoc = this.reader.maxDoc();
            this.iterator = DocIdSetIterator.all((int)context.reader().maxDoc());
            this.vals = FunctionQuery.this.func.getValues(this.weight.context, context);
        }

        public DocIdSetIterator iterator() {
            return this.iterator;
        }

        public int docID() {
            return this.iterator.docID();
        }

        public float score() throws IOException {
            float score = this.boost * this.vals.floatVal(this.docID());
            return score > Float.NEGATIVE_INFINITY ? score : -3.4028235E38f;
        }

        public int freq() throws IOException {
            return 1;
        }

        public Explanation explain(int doc) throws IOException {
            float sc = this.boost * this.vals.floatVal(doc);
            return Explanation.match((float)sc, (String)("FunctionQuery(" + FunctionQuery.this.func + "), product of:"), (Explanation[])new Explanation[]{this.vals.explain(doc), Explanation.match((float)this.weight.boost, (String)"boost", (Explanation[])new Explanation[0])});
        }
    }

    protected class FunctionWeight
    extends Weight {
        protected final IndexSearcher searcher;
        protected final float boost;
        protected final Map context;

        public FunctionWeight(IndexSearcher searcher, float boost) throws IOException {
            super((Query)FunctionQuery.this);
            this.searcher = searcher;
            this.context = ValueSource.newContext(searcher);
            FunctionQuery.this.func.createWeight(this.context, searcher);
            this.boost = boost;
        }

        public void extractTerms(Set<Term> terms) {
        }

        public Scorer scorer(LeafReaderContext context) throws IOException {
            return new AllScorer(context, this, this.boost);
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            return ((AllScorer)this.scorer(context)).explain(doc);
        }
    }
}

