/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries;

import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;

public class TermsFilter
extends Filter {
    private final Set<Term> terms = new TreeSet<Term>();

    public void addTerm(Term term) {
        this.terms.add(term);
    }

    public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
        AtomicReader reader = context.reader();
        FixedBitSet result = new FixedBitSet(reader.maxDoc());
        Fields fields = reader.fields();
        if (fields == null) {
            return result;
        }
        BytesRef br = new BytesRef();
        String lastField = null;
        TermsEnum termsEnum = null;
        DocsEnum docs = null;
        for (Term term : this.terms) {
            if (!term.field().equals(lastField)) {
                Terms termsC = fields.terms(term.field());
                if (termsC == null) {
                    return result;
                }
                termsEnum = termsC.iterator(null);
                lastField = term.field();
            }
            if (this.terms == null) continue;
            br.copyBytes(term.bytes());
            assert (termsEnum != null);
            if (termsEnum.seekCeil(br) != TermsEnum.SeekStatus.FOUND) continue;
            docs = termsEnum.docs(acceptDocs, docs, false);
            while (docs.nextDoc() != Integer.MAX_VALUE) {
                result.set(docs.docID());
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        TermsFilter test = (TermsFilter)((Object)obj);
        return this.terms == test.terms || this.terms != null && ((Object)this.terms).equals(test.terms);
    }

    public int hashCode() {
        int hash = 9;
        for (Term term : this.terms) {
            hash = 31 * hash + term.hashCode();
        }
        return hash;
    }
}

