/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortingMergePolicy;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FilterCollector;
import org.apache.lucene.search.FilterLeafCollector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;

public class EarlyTerminatingSortingCollector
extends FilterCollector {
    protected final Sort sort;
    protected final int numDocsToCollect;
    private final SortingMergePolicy mergePolicy;

    public static boolean canEarlyTerminate(Sort sort, SortingMergePolicy mergePolicy) {
        SortField[] fields2;
        SortField[] fields1 = sort.getSort();
        if (fields1.length > (fields2 = mergePolicy.getSort().getSort()).length) {
            return false;
        }
        return Arrays.asList(fields1).equals(Arrays.asList(fields2).subList(0, fields1.length));
    }

    public EarlyTerminatingSortingCollector(Collector in, Sort sort, int numDocsToCollect, SortingMergePolicy mergePolicy) {
        super(in);
        if (numDocsToCollect <= 0) {
            throw new IllegalArgumentException("numDocsToCollect must always be > 0, got " + numDocsToCollect);
        }
        if (!EarlyTerminatingSortingCollector.canEarlyTerminate(sort, mergePolicy)) {
            throw new IllegalStateException("Cannot early terminate with sort order " + sort + " if segments are sorted with " + mergePolicy.getSort());
        }
        this.sort = sort;
        this.numDocsToCollect = numDocsToCollect;
        this.mergePolicy = mergePolicy;
    }

    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        if (this.mergePolicy.isSorted(context.reader())) {
            return new FilterLeafCollector(super.getLeafCollector(context)){
                private int numCollected;

                public void collect(int doc) throws IOException {
                    super.collect(doc);
                    if (++this.numCollected >= EarlyTerminatingSortingCollector.this.numDocsToCollect) {
                        throw new CollectionTerminatedException();
                    }
                }
            };
        }
        return super.getLeafCollector(context);
    }
}

