/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.util.BytesRef;

public class LazyDocument {
    private IndexReader reader;
    private final int docID;
    private Document doc;
    private Map<Integer, Integer> fields = new HashMap<Integer, Integer>();

    public LazyDocument(IndexReader reader, int docID) {
        this.reader = reader;
        this.docID = docID;
    }

    public IndexableField getField(FieldInfo fieldInfo) {
        Integer num = this.fields.get(fieldInfo.number);
        if (num == null) {
            num = 0;
        } else {
            Integer n = num;
            Integer n2 = num = Integer.valueOf(num + 1);
        }
        this.fields.put(fieldInfo.number, num);
        return new LazyField(fieldInfo.name, num);
    }

    private synchronized Document getDocument() {
        if (this.doc == null) {
            try {
                this.doc = this.reader.document(this.docID);
            }
            catch (IOException ioe) {
                throw new IllegalStateException("unable to load document", ioe);
            }
            this.reader = null;
        }
        return this.doc;
    }

    private class LazyField
    implements IndexableField {
        private String name;
        private int num;

        public LazyField(String name, int num) {
            this.name = name;
            this.num = num;
        }

        public String name() {
            return this.name;
        }

        public float boost() {
            return 1.0f;
        }

        public BytesRef binaryValue() {
            if (this.num == 0) {
                return LazyDocument.this.getDocument().getField(this.name).binaryValue();
            }
            return LazyDocument.this.getDocument().getFields(this.name)[this.num].binaryValue();
        }

        public String stringValue() {
            if (this.num == 0) {
                return LazyDocument.this.getDocument().getField(this.name).stringValue();
            }
            return LazyDocument.this.getDocument().getFields(this.name)[this.num].stringValue();
        }

        public Reader readerValue() {
            if (this.num == 0) {
                return LazyDocument.this.getDocument().getField(this.name).readerValue();
            }
            return LazyDocument.this.getDocument().getFields(this.name)[this.num].readerValue();
        }

        public Number numericValue() {
            if (this.num == 0) {
                return LazyDocument.this.getDocument().getField(this.name).numericValue();
            }
            return LazyDocument.this.getDocument().getFields(this.name)[this.num].numericValue();
        }

        public IndexableFieldType fieldType() {
            if (this.num == 0) {
                return LazyDocument.this.getDocument().getField(this.name).fieldType();
            }
            return LazyDocument.this.getDocument().getFields(this.name)[this.num].fieldType();
        }

        public TokenStream tokenStream(Analyzer analyzer) throws IOException {
            if (this.num == 0) {
                return LazyDocument.this.getDocument().getField(this.name).tokenStream(analyzer);
            }
            return LazyDocument.this.getDocument().getFields(this.name)[this.num].tokenStream(analyzer);
        }
    }
}

