/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.TermRangeFilter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.ReaderUtil;
import org.apache.lucene.util.Version;

public class PKIndexSplitter {
    private final Filter docsInFirstIndex;
    private final Directory input;
    private final Directory dir1;
    private final Directory dir2;
    private final IndexWriterConfig config1;
    private final IndexWriterConfig config2;

    @Deprecated
    public PKIndexSplitter(Directory input, Directory dir1, Directory dir2, Filter docsInFirstIndex) {
        this(Version.LUCENE_CURRENT, input, dir1, dir2, docsInFirstIndex);
    }

    @Deprecated
    public PKIndexSplitter(Directory input, Directory dir1, Directory dir2, Term midTerm) {
        this(input, dir1, dir2, (Filter)new TermRangeFilter(midTerm.field(), null, midTerm.text(), true, false));
    }

    public PKIndexSplitter(Version version, Directory input, Directory dir1, Directory dir2, Filter docsInFirstIndex) {
        this(input, dir1, dir2, docsInFirstIndex, PKIndexSplitter.newDefaultConfig(version), PKIndexSplitter.newDefaultConfig(version));
    }

    private static IndexWriterConfig newDefaultConfig(Version version) {
        return new IndexWriterConfig(version, null).setOpenMode(IndexWriterConfig.OpenMode.CREATE);
    }

    public PKIndexSplitter(Directory input, Directory dir1, Directory dir2, Filter docsInFirstIndex, IndexWriterConfig config1, IndexWriterConfig config2) {
        this.input = input;
        this.dir1 = dir1;
        this.dir2 = dir2;
        this.docsInFirstIndex = docsInFirstIndex;
        this.config1 = config1;
        this.config2 = config2;
    }

    public PKIndexSplitter(Version version, Directory input, Directory dir1, Directory dir2, Term midTerm) {
        this(version, input, dir1, dir2, (Filter)new TermRangeFilter(midTerm.field(), null, midTerm.text(), true, false));
    }

    public PKIndexSplitter(Directory input, Directory dir1, Directory dir2, Term midTerm, IndexWriterConfig config1, IndexWriterConfig config2) {
        this(input, dir1, dir2, (Filter)new TermRangeFilter(midTerm.field(), null, midTerm.text(), true, false), config1, config2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void split() throws IOException {
        block5: {
            IndexReader reader;
            block4: {
                boolean success = false;
                reader = IndexReader.open((Directory)this.input);
                try {
                    this.createIndex(this.config1, this.dir1, reader, this.docsInFirstIndex, false);
                    this.createIndex(this.config2, this.dir2, reader, this.docsInFirstIndex, true);
                    success = true;
                    if (!success) break block4;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{reader});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{reader});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{reader});
                break block5;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{reader});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndex(IndexWriterConfig config, Directory target, IndexReader reader, Filter preserveFilter, boolean negateFilter) throws IOException {
        block6: {
            IndexWriter w;
            block5: {
                boolean success = false;
                w = new IndexWriter(target, config);
                try {
                    ArrayList leaves = new ArrayList();
                    ReaderUtil.gatherSubReaders(leaves, (IndexReader)reader);
                    IndexReader[] subReaders = new IndexReader[leaves.size()];
                    for (int i = 0; i < subReaders.length; ++i) {
                        subReaders[i] = new DocumentFilteredAtomicIndexReader((IndexReader)leaves.get(i), preserveFilter, negateFilter);
                    }
                    w.addIndexes(subReaders);
                    success = true;
                    if (!success) break block5;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{w});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{w});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{w});
                break block6;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{w});
        }
    }

    private static class DocumentFilteredAtomicIndexReader
    extends FilterIndexReader {
        final FixedBitSet readerDels;
        final int numDocs;

        public DocumentFilteredAtomicIndexReader(IndexReader reader, Filter preserveFilter, boolean negateFilter) throws IOException {
            super(reader);
            DocIdSetIterator it;
            assert (this.in.getSequentialSubReaders() == null);
            FixedBitSet bits = new FixedBitSet(this.in.maxDoc());
            DocIdSet docs = preserveFilter.getDocIdSet(this.in);
            if (docs != null && (it = docs.iterator()) != null) {
                bits.or(it);
            }
            if (!negateFilter) {
                bits.flip(0, this.in.maxDoc());
            }
            if (this.in.hasDeletions()) {
                for (int i = 0; i < this.in.maxDoc(); ++i) {
                    if (!this.in.isDeleted(i)) continue;
                    bits.set(i);
                }
            }
            this.readerDels = bits;
            this.numDocs = this.in.maxDoc() - bits.cardinality();
        }

        public int numDocs() {
            return this.numDocs;
        }

        public boolean hasDeletions() {
            return this.in.maxDoc() != this.numDocs;
        }

        public boolean isDeleted(int n) {
            return this.readerDels.get(n);
        }

        public IndexReader[] getSequentialSubReaders() {
            return null;
        }

        public TermPositions termPositions() throws IOException {
            return new FilterIndexReader.FilterTermPositions(this.in.termPositions()){

                public boolean next() throws IOException {
                    boolean res;
                    while ((res = super.next()) && DocumentFilteredAtomicIndexReader.this.readerDels.get(this.doc())) {
                    }
                    return res;
                }
            };
        }
    }
}

