/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.precedence;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.precedence.CharStream;
import org.apache.lucene.queryParser.precedence.FastCharStream;
import org.apache.lucene.queryParser.precedence.ParseException;
import org.apache.lucene.queryParser.precedence.PrecedenceQueryParserConstants;
import org.apache.lucene.queryParser.precedence.PrecedenceQueryParserTokenManager;
import org.apache.lucene.queryParser.precedence.Token;
import org.apache.lucene.queryParser.precedence.TokenMgrError;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.AttributeSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrecedenceQueryParser
implements PrecedenceQueryParserConstants {
    private static final int CONJ_NONE = 0;
    private static final int CONJ_AND = 1;
    private static final int CONJ_OR = 2;
    private static final int MOD_NONE = 0;
    private static final int MOD_NOT = 10;
    private static final int MOD_REQ = 11;
    public static final Operator AND_OPERATOR = Operator.AND;
    public static final Operator OR_OPERATOR = Operator.OR;
    private Operator operator = OR_OPERATOR;
    boolean lowercaseExpandedTerms = true;
    Analyzer analyzer;
    String field;
    int phraseSlop = 0;
    float fuzzyMinSim = 0.5f;
    int fuzzyPrefixLength = 0;
    Locale locale = Locale.getDefault();
    public PrecedenceQueryParserTokenManager token_source;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[24];
    private static int[] jj_la1_0;
    private final JJCalls[] jj_2_rtns = new JJCalls[1];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public PrecedenceQueryParser(String f, Analyzer a) {
        this(new FastCharStream(new StringReader("")));
        this.analyzer = a;
        this.field = f;
    }

    public Query parse(String expression) throws ParseException {
        if (expression == null || expression.trim().length() == 0) {
            return new BooleanQuery();
        }
        this.ReInit(new FastCharStream(new StringReader(expression)));
        try {
            Query query = this.Query(this.field);
            return query != null ? query : new BooleanQuery();
        }
        catch (TokenMgrError tme) {
            throw new ParseException(tme.getMessage());
        }
        catch (BooleanQuery.TooManyClauses tmc) {
            throw new ParseException("Too many boolean clauses");
        }
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public String getField() {
        return this.field;
    }

    public float getFuzzyMinSim() {
        return this.fuzzyMinSim;
    }

    public void setFuzzyMinSim(float fuzzyMinSim) {
        this.fuzzyMinSim = fuzzyMinSim;
    }

    public int getFuzzyPrefixLength() {
        return this.fuzzyPrefixLength;
    }

    public void setFuzzyPrefixLength(int fuzzyPrefixLength) {
        this.fuzzyPrefixLength = fuzzyPrefixLength;
    }

    public void setPhraseSlop(int phraseSlop) {
        this.phraseSlop = phraseSlop;
    }

    public int getPhraseSlop() {
        return this.phraseSlop;
    }

    public void setDefaultOperator(Operator op) {
        this.operator = op;
    }

    public Operator getDefaultOperator() {
        return this.operator;
    }

    public void setLowercaseExpandedTerms(boolean lowercaseExpandedTerms) {
        this.lowercaseExpandedTerms = lowercaseExpandedTerms;
    }

    public boolean getLowercaseExpandedTerms() {
        return this.lowercaseExpandedTerms;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    protected void addClause(List<BooleanClause> clauses, int conj, int modifier, Query q) {
        boolean required;
        boolean prohibited;
        BooleanClause c;
        if (clauses.size() > 0 && conj == 1 && !(c = clauses.get(clauses.size() - 1)).isProhibited()) {
            c.setOccur(BooleanClause.Occur.MUST);
        }
        if (clauses.size() > 0 && this.operator == AND_OPERATOR && conj == 2 && !(c = clauses.get(clauses.size() - 1)).isProhibited()) {
            c.setOccur(BooleanClause.Occur.SHOULD);
        }
        if (q == null) {
            return;
        }
        if (this.operator == OR_OPERATOR) {
            prohibited = modifier == 10;
            boolean bl = required = modifier == 11;
            if (conj == 1 && !prohibited) {
                required = true;
            }
        } else {
            prohibited = modifier == 10;
            boolean bl = required = !prohibited && conj != 2;
        }
        if (required && !prohibited) {
            clauses.add(new BooleanClause(q, BooleanClause.Occur.MUST));
        } else if (!required && !prohibited) {
            clauses.add(new BooleanClause(q, BooleanClause.Occur.SHOULD));
        } else if (!required && prohibited) {
            clauses.add(new BooleanClause(q, BooleanClause.Occur.MUST_NOT));
        } else {
            throw new RuntimeException("Clause cannot be both required and prohibited");
        }
    }

    protected Query getFieldQuery(String field, String queryText) throws ParseException {
        TokenStream source = this.analyzer.tokenStream(field, (Reader)new StringReader(queryText));
        ArrayList<AttributeSource.State> list = new ArrayList<AttributeSource.State>();
        int positionCount = 0;
        boolean severalTokensAtSamePosition = false;
        TermAttribute termAtt = (TermAttribute)source.addAttribute(TermAttribute.class);
        PositionIncrementAttribute posincrAtt = (PositionIncrementAttribute)source.addAttribute(PositionIncrementAttribute.class);
        try {
            while (source.incrementToken()) {
                list.add(source.captureState());
                if (posincrAtt.getPositionIncrement() == 1) {
                    ++positionCount;
                    continue;
                }
                severalTokensAtSamePosition = true;
            }
            source.end();
            source.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (list.size() == 0) {
            return null;
        }
        if (list.size() == 1) {
            source.restoreState((AttributeSource.State)list.get(0));
            return new TermQuery(new Term(field, termAtt.term()));
        }
        if (severalTokensAtSamePosition) {
            if (positionCount == 1) {
                BooleanQuery q = new BooleanQuery();
                for (int i = 0; i < list.size(); ++i) {
                    source.restoreState((AttributeSource.State)list.get(i));
                    TermQuery currentQuery = new TermQuery(new Term(field, termAtt.term()));
                    q.add((Query)currentQuery, BooleanClause.Occur.SHOULD);
                }
                return q;
            }
            MultiPhraseQuery mpq = new MultiPhraseQuery();
            ArrayList<Term> multiTerms = new ArrayList<Term>();
            for (int i = 0; i < list.size(); ++i) {
                source.restoreState((AttributeSource.State)list.get(i));
                if (posincrAtt.getPositionIncrement() == 1 && multiTerms.size() > 0) {
                    mpq.add(multiTerms.toArray(new Term[0]));
                    multiTerms.clear();
                }
                multiTerms.add(new Term(field, termAtt.term()));
            }
            mpq.add(multiTerms.toArray(new Term[0]));
            return mpq;
        }
        PhraseQuery q = new PhraseQuery();
        q.setSlop(this.phraseSlop);
        for (int i = 0; i < list.size(); ++i) {
            source.restoreState((AttributeSource.State)list.get(i));
            q.add(new Term(field, termAtt.term()));
        }
        return q;
    }

    protected Query getFieldQuery(String field, String queryText, int slop) throws ParseException {
        Query query = this.getFieldQuery(field, queryText);
        if (query instanceof PhraseQuery) {
            ((PhraseQuery)query).setSlop(slop);
        }
        if (query instanceof MultiPhraseQuery) {
            ((MultiPhraseQuery)query).setSlop(slop);
        }
        return query;
    }

    protected Query getRangeQuery(String field, String part1, String part2, boolean inclusive) throws ParseException {
        if (this.lowercaseExpandedTerms) {
            part1 = part1.toLowerCase();
            part2 = part2.toLowerCase();
        }
        try {
            DateFormat df = DateFormat.getDateInstance(3, this.locale);
            df.setLenient(true);
            Date d1 = df.parse(part1);
            Date d2 = df.parse(part2);
            part1 = DateTools.dateToString((Date)d1, (DateTools.Resolution)DateTools.Resolution.DAY);
            part2 = DateTools.dateToString((Date)d2, (DateTools.Resolution)DateTools.Resolution.DAY);
        }
        catch (Exception e) {
            // empty catch block
        }
        return new TermRangeQuery(field, part1, part2, inclusive, inclusive);
    }

    protected Query getBooleanQuery(List<BooleanClause> clauses) throws ParseException {
        return this.getBooleanQuery(clauses, false);
    }

    protected Query getBooleanQuery(List<BooleanClause> clauses, boolean disableCoord) throws ParseException {
        if (clauses == null || clauses.size() == 0) {
            return null;
        }
        BooleanQuery query = new BooleanQuery(disableCoord);
        for (int i = 0; i < clauses.size(); ++i) {
            query.add(clauses.get(i));
        }
        return query;
    }

    protected Query getWildcardQuery(String field, String termStr) throws ParseException {
        if (this.lowercaseExpandedTerms) {
            termStr = termStr.toLowerCase();
        }
        Term t = new Term(field, termStr);
        return new WildcardQuery(t);
    }

    protected Query getPrefixQuery(String field, String termStr) throws ParseException {
        if (this.lowercaseExpandedTerms) {
            termStr = termStr.toLowerCase();
        }
        Term t = new Term(field, termStr);
        return new PrefixQuery(t);
    }

    protected Query getFuzzyQuery(String field, String termStr, float minSimilarity) throws ParseException {
        if (this.lowercaseExpandedTerms) {
            termStr = termStr.toLowerCase();
        }
        Term t = new Term(field, termStr);
        return new FuzzyQuery(t, minSimilarity, this.fuzzyPrefixLength);
    }

    private String discardEscapeChar(String input) {
        char[] caSource = input.toCharArray();
        char[] caDest = new char[caSource.length];
        int j = 0;
        for (int i = 0; i < caSource.length; ++i) {
            if (caSource[i] == '\\' && (i <= 0 || caSource[i - 1] != '\\')) continue;
            caDest[j++] = caSource[i];
        }
        return new String(caDest, 0, j);
    }

    public static String escape(String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '+' || c == '-' || c == '!' || c == '(' || c == ')' || c == ':' || c == '^' || c == '[' || c == ']' || c == '\"' || c == '{' || c == '}' || c == '~' || c == '*' || c == '?') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Usage: java org.apache.lucene.queryParser.QueryParser <input>");
            System.exit(0);
        }
        PrecedenceQueryParser qp = new PrecedenceQueryParser("field", (Analyzer)new SimpleAnalyzer());
        Query q = qp.parse(args[0]);
        System.out.println(q.toString("field"));
    }

    public final int Conjunction() throws ParseException {
        int ret = 0;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: 
            case 8: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: {
                        this.jj_consume_token(7);
                        ret = 1;
                        break block0;
                    }
                    case 8: {
                        this.jj_consume_token(8);
                        ret = 2;
                        break block0;
                    }
                }
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        return ret;
    }

    public final int Modifier() throws ParseException {
        int ret = 0;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: 
            case 10: 
            case 11: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: {
                        this.jj_consume_token(10);
                        ret = 11;
                        break block0;
                    }
                    case 11: {
                        this.jj_consume_token(11);
                        ret = 10;
                        break block0;
                    }
                    case 9: {
                        this.jj_consume_token(9);
                        ret = 10;
                        break block0;
                    }
                }
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        return ret;
    }

    public final Query Query(String field) throws ParseException {
        ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
        Query firstQuery = null;
        boolean orPresent = false;
        int modifier = this.Modifier();
        Query q = this.andExpression(field);
        this.addClause(clauses, 0, modifier, q);
        if (modifier == 0) {
            firstQuery = q;
        }
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 16: 
                case 17: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block6;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    this.jj_consume_token(8);
                    orPresent = true;
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                }
            }
            modifier = this.Modifier();
            q = this.andExpression(field);
            this.addClause(clauses, orPresent ? 2 : 0, modifier, q);
        }
        if (clauses.size() == 1 && firstQuery != null) {
            return firstQuery;
        }
        return this.getBooleanQuery(clauses);
    }

    public final Query andExpression(String field) throws ParseException {
        ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
        Query firstQuery = null;
        Query q = this.Clause(field);
        this.addClause(clauses, 0, 0, q);
        firstQuery = q;
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: {
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(7);
            int modifier = this.Modifier();
            q = this.Clause(field);
            this.addClause(clauses, 1, modifier, q);
        }
        if (clauses.size() == 1 && firstQuery != null) {
            return firstQuery;
        }
        return this.getBooleanQuery(clauses);
    }

    public final Query Clause(String field) throws ParseException {
        Query q;
        Token fieldToken = null;
        Token boost = null;
        if (this.jj_2_1(2)) {
            fieldToken = this.jj_consume_token(17);
            this.jj_consume_token(14);
            field = this.discardEscapeChar(fieldToken.image);
        }
        block1 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                q = this.Term(field);
                break;
            }
            case 12: {
                this.jj_consume_token(12);
                q = this.Query(field);
                this.jj_consume_token(13);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: {
                        this.jj_consume_token(15);
                        boost = this.jj_consume_token(23);
                        break block1;
                    }
                }
                this.jj_la1[7] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (boost != null) {
            float f = 1.0f;
            try {
                f = Float.valueOf(boost.image).floatValue();
                q.setBoost(f);
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        return q;
    }

    public final Query Term(String field) throws ParseException {
        Query q;
        Token boost = null;
        Token fuzzySlop = null;
        boolean prefix = false;
        boolean wildcard = false;
        boolean fuzzy = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: 
            case 19: 
            case 20: 
            case 23: {
                Token term;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 17: {
                        term = this.jj_consume_token(17);
                        break;
                    }
                    case 19: {
                        term = this.jj_consume_token(19);
                        prefix = true;
                        break;
                    }
                    case 20: {
                        term = this.jj_consume_token(20);
                        wildcard = true;
                        break;
                    }
                    case 23: {
                        term = this.jj_consume_token(23);
                        break;
                    }
                    default: {
                        this.jj_la1[9] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 18: {
                        fuzzySlop = this.jj_consume_token(18);
                        fuzzy = true;
                        break;
                    }
                    default: {
                        this.jj_la1[10] = this.jj_gen;
                    }
                }
                block18 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: {
                        this.jj_consume_token(15);
                        boost = this.jj_consume_token(23);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 18: {
                                fuzzySlop = this.jj_consume_token(18);
                                fuzzy = true;
                                break block18;
                            }
                        }
                        this.jj_la1[11] = this.jj_gen;
                        break;
                    }
                    default: {
                        this.jj_la1[12] = this.jj_gen;
                    }
                }
                String termImage = this.discardEscapeChar(term.image);
                if (wildcard) {
                    q = this.getWildcardQuery(field, termImage);
                    break;
                }
                if (prefix) {
                    q = this.getPrefixQuery(field, this.discardEscapeChar(term.image.substring(0, term.image.length() - 1)));
                    break;
                }
                if (fuzzy) {
                    float fms = this.fuzzyMinSim;
                    try {
                        fms = Float.valueOf(fuzzySlop.image.substring(1)).floatValue();
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                    if (fms < 0.0f || fms > 1.0f) {
                        throw new ParseException("Minimum similarity for a FuzzyQuery has to be between 0.0f and 1.0f !");
                    }
                    q = this.getFuzzyQuery(field, termImage, fms);
                    break;
                }
                q = this.getFieldQuery(field, termImage);
                break;
            }
            case 21: {
                Token goop2;
                Token goop1;
                this.jj_consume_token(21);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 27: {
                        goop1 = this.jj_consume_token(27);
                        break;
                    }
                    case 26: {
                        goop1 = this.jj_consume_token(26);
                        break;
                    }
                    default: {
                        this.jj_la1[13] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 24: {
                        this.jj_consume_token(24);
                        break;
                    }
                    default: {
                        this.jj_la1[14] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 27: {
                        goop2 = this.jj_consume_token(27);
                        break;
                    }
                    case 26: {
                        goop2 = this.jj_consume_token(26);
                        break;
                    }
                    default: {
                        this.jj_la1[15] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(25);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: {
                        this.jj_consume_token(15);
                        boost = this.jj_consume_token(23);
                        break;
                    }
                    default: {
                        this.jj_la1[16] = this.jj_gen;
                    }
                }
                goop1.image = goop1.kind == 26 ? goop1.image.substring(1, goop1.image.length() - 1) : this.discardEscapeChar(goop1.image);
                goop2.image = goop2.kind == 26 ? goop2.image.substring(1, goop2.image.length() - 1) : this.discardEscapeChar(goop2.image);
                q = this.getRangeQuery(field, goop1.image, goop2.image, true);
                break;
            }
            case 22: {
                Token goop2;
                Token goop1;
                this.jj_consume_token(22);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 31: {
                        goop1 = this.jj_consume_token(31);
                        break;
                    }
                    case 30: {
                        goop1 = this.jj_consume_token(30);
                        break;
                    }
                    default: {
                        this.jj_la1[17] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 28: {
                        this.jj_consume_token(28);
                        break;
                    }
                    default: {
                        this.jj_la1[18] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 31: {
                        goop2 = this.jj_consume_token(31);
                        break;
                    }
                    case 30: {
                        goop2 = this.jj_consume_token(30);
                        break;
                    }
                    default: {
                        this.jj_la1[19] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(29);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: {
                        this.jj_consume_token(15);
                        boost = this.jj_consume_token(23);
                        break;
                    }
                    default: {
                        this.jj_la1[20] = this.jj_gen;
                    }
                }
                goop1.image = goop1.kind == 30 ? goop1.image.substring(1, goop1.image.length() - 1) : this.discardEscapeChar(goop1.image);
                goop2.image = goop2.kind == 30 ? goop2.image.substring(1, goop2.image.length() - 1) : this.discardEscapeChar(goop2.image);
                q = this.getRangeQuery(field, goop1.image, goop2.image, false);
                break;
            }
            case 16: {
                Token term = this.jj_consume_token(16);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 18: {
                        fuzzySlop = this.jj_consume_token(18);
                        break;
                    }
                    default: {
                        this.jj_la1[21] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: {
                        this.jj_consume_token(15);
                        boost = this.jj_consume_token(23);
                        break;
                    }
                    default: {
                        this.jj_la1[22] = this.jj_gen;
                    }
                }
                int s = this.phraseSlop;
                if (fuzzySlop != null) {
                    try {
                        s = Float.valueOf(fuzzySlop.image.substring(1)).intValue();
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                }
                q = this.getFieldQuery(field, term.image.substring(1, term.image.length() - 1), s);
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (boost != null) {
            float f = 1.0f;
            try {
                f = Float.valueOf(boost.image).floatValue();
            }
            catch (Exception ignored) {
                // empty catch block
            }
            if (q != null) {
                q.setBoost(f);
            }
        }
        return q;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    private boolean jj_3_1() {
        if (this.jj_scan_token(17)) {
            return true;
        }
        return this.jj_scan_token(14);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{384, 384, 3584, 3584, 16457472, 256, 128, 32768, 16453632, 0x9A0000, 262144, 262144, 32768, 0xC000000, 0x1000000, 0xC000000, 32768, -1073741824, 0x10000000, -1073741824, 32768, 262144, 32768, 0xFB0000};
    }

    public PrecedenceQueryParser(CharStream stream) {
        int i;
        this.token_source = new PrecedenceQueryParserTokenManager(stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 24; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(CharStream stream) {
        int i;
        this.token_source.ReInit(stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 24; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public PrecedenceQueryParser(PrecedenceQueryParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 24; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(PrecedenceQueryParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 24; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[32];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 24; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 32; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 1; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        PrecedenceQueryParser.jj_la1_init_0();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Operator {
        OR,
        AND;

    }
}

