/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.uhighlight;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.uhighlight.FieldOffsetStrategy;
import org.apache.lucene.search.uhighlight.OffsetsEnum;
import org.apache.lucene.search.uhighlight.PhraseHelper;
import org.apache.lucene.search.uhighlight.UnifiedHighlighter;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;

public class PostingsOffsetStrategy
extends FieldOffsetStrategy {
    public PostingsOffsetStrategy(String field, BytesRef[] queryTerms, PhraseHelper phraseHelper, CharacterRunAutomaton[] automata) {
        super(field, queryTerms, phraseHelper, automata);
    }

    @Override
    public OffsetsEnum getOffsetsEnum(IndexReader reader, int docId, String content) throws IOException {
        LeafReader leafReader;
        if (reader instanceof LeafReader) {
            leafReader = (LeafReader)reader;
        } else {
            List leaves = reader.leaves();
            LeafReaderContext leafReaderContext = (LeafReaderContext)leaves.get(ReaderUtil.subIndex((int)docId, (List)leaves));
            leafReader = leafReaderContext.reader();
            docId -= leafReaderContext.docBase;
        }
        return this.createOffsetsEnumFromReader(leafReader, docId);
    }

    @Override
    public UnifiedHighlighter.OffsetSource getOffsetSource() {
        return UnifiedHighlighter.OffsetSource.POSTINGS;
    }
}

