/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.facetset;

import java.util.stream.IntStream;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.facet.facetset.FacetSet;
import org.apache.lucene.util.NumericUtils;

public class FloatFacetSet
extends FacetSet {
    public final float[] values;

    public FloatFacetSet(float ... values) {
        super(FloatFacetSet.validateValuesAndGetNumDims(values));
        this.values = values;
    }

    @Override
    public long[] getComparableValues() {
        return IntStream.range(0, this.values.length).mapToLong(idx -> NumericUtils.floatToSortableInt((float)this.values[idx])).toArray();
    }

    @Override
    public int packValues(byte[] buf, int start) {
        int i = 0;
        int offset = start;
        while (i < this.values.length) {
            FloatPoint.encodeDimension((float)this.values[i], (byte[])buf, (int)offset);
            ++i;
            offset += 4;
        }
        return this.values.length * 4;
    }

    @Override
    public int sizePackedBytes() {
        return this.dims * 4;
    }

    private static int validateValuesAndGetNumDims(float ... values) {
        if (values == null || values.length == 0) {
            throw new IllegalArgumentException("values cannot be null or empty");
        }
        return values.length;
    }
}

