/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.codecs.SegmentInfoFormat;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexSorter;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SortFieldProvider;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.CollectionUtil;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.Version;

public class SimpleTextSegmentInfoFormat
extends SegmentInfoFormat {
    static final BytesRef SI_VERSION = new BytesRef((CharSequence)"    version ");
    static final BytesRef SI_MIN_VERSION = new BytesRef((CharSequence)"    min version ");
    static final BytesRef SI_DOCCOUNT = new BytesRef((CharSequence)"    number of documents ");
    static final BytesRef SI_USECOMPOUND = new BytesRef((CharSequence)"    uses compound file ");
    static final BytesRef SI_NUM_DIAG = new BytesRef((CharSequence)"    diagnostics ");
    static final BytesRef SI_DIAG_KEY = new BytesRef((CharSequence)"      key ");
    static final BytesRef SI_DIAG_VALUE = new BytesRef((CharSequence)"      value ");
    static final BytesRef SI_NUM_ATT = new BytesRef((CharSequence)"    attributes ");
    static final BytesRef SI_ATT_KEY = new BytesRef((CharSequence)"      key ");
    static final BytesRef SI_ATT_VALUE = new BytesRef((CharSequence)"      value ");
    static final BytesRef SI_NUM_FILES = new BytesRef((CharSequence)"    files ");
    static final BytesRef SI_FILE = new BytesRef((CharSequence)"      file ");
    static final BytesRef SI_ID = new BytesRef((CharSequence)"    id ");
    static final BytesRef SI_SORT = new BytesRef((CharSequence)"    sort ");
    static final BytesRef SI_SORT_TYPE = new BytesRef((CharSequence)"      type ");
    static final BytesRef SI_SORT_NAME = new BytesRef((CharSequence)"      name ");
    static final BytesRef SI_SORT_BYTES = new BytesRef((CharSequence)"      bytes ");
    public static final String SI_EXTENSION = "si";

    public SegmentInfo read(Directory directory, String segmentName, byte[] segmentID, IOContext context) throws IOException {
        BytesRefBuilder scratch = new BytesRefBuilder();
        String segFileName = IndexFileNames.segmentFileName((String)segmentName, (String)"", (String)SI_EXTENSION);
        try (ChecksumIndexInput input = directory.openChecksumInput(segFileName, context);){
            Version minVersion;
            Version version;
            SimpleTextUtil.readLine((DataInput)input, scratch);
            assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_VERSION));
            try {
                version = Version.parse((String)this.readString(SimpleTextSegmentInfoFormat.SI_VERSION.length, scratch));
            }
            catch (ParseException pe) {
                throw new CorruptIndexException("unable to parse version string: " + pe.getMessage(), (DataInput)input, (Throwable)pe);
            }
            SimpleTextUtil.readLine((DataInput)input, scratch);
            assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_MIN_VERSION));
            try {
                String versionString = this.readString(SimpleTextSegmentInfoFormat.SI_MIN_VERSION.length, scratch);
                minVersion = versionString.equals("null") ? null : Version.parse((String)versionString);
            }
            catch (ParseException pe) {
                throw new CorruptIndexException("unable to parse version string: " + pe.getMessage(), (DataInput)input, (Throwable)pe);
            }
            SimpleTextUtil.readLine((DataInput)input, scratch);
            assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_DOCCOUNT));
            int docCount = Integer.parseInt(this.readString(SimpleTextSegmentInfoFormat.SI_DOCCOUNT.length, scratch));
            SimpleTextUtil.readLine((DataInput)input, scratch);
            assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_USECOMPOUND));
            boolean isCompoundFile = Boolean.parseBoolean(this.readString(SimpleTextSegmentInfoFormat.SI_USECOMPOUND.length, scratch));
            SimpleTextUtil.readLine((DataInput)input, scratch);
            assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_NUM_DIAG));
            int numDiag = Integer.parseInt(this.readString(SimpleTextSegmentInfoFormat.SI_NUM_DIAG.length, scratch));
            HashMap diagnostics = CollectionUtil.newHashMap((int)numDiag);
            for (int i = 0; i < numDiag; ++i) {
                SimpleTextUtil.readLine((DataInput)input, scratch);
                assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_DIAG_KEY));
                String key = this.readString(SimpleTextSegmentInfoFormat.SI_DIAG_KEY.length, scratch);
                SimpleTextUtil.readLine((DataInput)input, scratch);
                assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_DIAG_VALUE));
                String value = this.readString(SimpleTextSegmentInfoFormat.SI_DIAG_VALUE.length, scratch);
                diagnostics.put(key, value);
            }
            SimpleTextUtil.readLine((DataInput)input, scratch);
            assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_NUM_ATT));
            int numAtt = Integer.parseInt(this.readString(SimpleTextSegmentInfoFormat.SI_NUM_ATT.length, scratch));
            HashMap attributes = CollectionUtil.newHashMap((int)numAtt);
            for (int i = 0; i < numAtt; ++i) {
                SimpleTextUtil.readLine((DataInput)input, scratch);
                assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_ATT_KEY));
                String key = this.readString(SimpleTextSegmentInfoFormat.SI_ATT_KEY.length, scratch);
                SimpleTextUtil.readLine((DataInput)input, scratch);
                assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_ATT_VALUE));
                String value = this.readString(SimpleTextSegmentInfoFormat.SI_ATT_VALUE.length, scratch);
                attributes.put(key, value);
            }
            SimpleTextUtil.readLine((DataInput)input, scratch);
            assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_NUM_FILES));
            int numFiles = Integer.parseInt(this.readString(SimpleTextSegmentInfoFormat.SI_NUM_FILES.length, scratch));
            HashSet files = CollectionUtil.newHashSet((int)numFiles);
            for (int i = 0; i < numFiles; ++i) {
                SimpleTextUtil.readLine((DataInput)input, scratch);
                assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_FILE));
                String fileName = this.readString(SimpleTextSegmentInfoFormat.SI_FILE.length, scratch);
                files.add(fileName);
            }
            SimpleTextUtil.readLine((DataInput)input, scratch);
            assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_ID));
            byte[] id = ArrayUtil.copyOfSubArray((byte[])scratch.bytes(), (int)SimpleTextSegmentInfoFormat.SI_ID.length, (int)scratch.length());
            if (!Arrays.equals(segmentID, id)) {
                throw new CorruptIndexException("file mismatch, expected: " + StringHelper.idToString((byte[])segmentID) + ", got: " + StringHelper.idToString((byte[])id), (DataInput)input);
            }
            SimpleTextUtil.readLine((DataInput)input, scratch);
            assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_SORT));
            int numSortFields = Integer.parseInt(this.readString(SimpleTextSegmentInfoFormat.SI_SORT.length, scratch));
            SortField[] sortField = new SortField[numSortFields];
            for (int i = 0; i < numSortFields; ++i) {
                SimpleTextUtil.readLine((DataInput)input, scratch);
                assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_SORT_NAME));
                String provider = this.readString(SimpleTextSegmentInfoFormat.SI_SORT_NAME.length, scratch);
                SimpleTextUtil.readLine((DataInput)input, scratch);
                assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_SORT_TYPE));
                SimpleTextUtil.readLine((DataInput)input, scratch);
                assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_SORT_BYTES));
                BytesRef serializedSort = SimpleTextUtil.fromBytesRefString(this.readString(SimpleTextSegmentInfoFormat.SI_SORT_BYTES.length, scratch));
                ByteArrayDataInput bytes = new ByteArrayDataInput(serializedSort.bytes, serializedSort.offset, serializedSort.length);
                sortField[i] = SortFieldProvider.forName((String)provider).readSortField((DataInput)bytes);
                assert (bytes.eof());
            }
            Sort indexSort = sortField.length == 0 ? null : new Sort(sortField);
            SimpleTextUtil.checkFooter(input);
            SegmentInfo info = new SegmentInfo(directory, version, minVersion, segmentName, docCount, isCompoundFile, null, (Map)diagnostics, id, (Map)attributes, indexSort);
            info.setFiles((Collection)files);
            SegmentInfo segmentInfo = info;
            return segmentInfo;
        }
    }

    private String readString(int offset, BytesRefBuilder scratch) {
        return new String(scratch.bytes(), offset, scratch.length() - offset, StandardCharsets.UTF_8);
    }

    public void write(Directory dir, SegmentInfo si, IOContext ioContext) throws IOException {
        String segFileName = IndexFileNames.segmentFileName((String)si.name, (String)"", (String)SI_EXTENSION);
        try (IndexOutput output = dir.createOutput(segFileName, ioContext);){
            si.addFile(segFileName);
            BytesRefBuilder scratch = new BytesRefBuilder();
            SimpleTextUtil.write((DataOutput)output, SI_VERSION);
            SimpleTextUtil.write((DataOutput)output, si.getVersion().toString(), scratch);
            SimpleTextUtil.writeNewline((DataOutput)output);
            SimpleTextUtil.write((DataOutput)output, SI_MIN_VERSION);
            if (si.getMinVersion() == null) {
                SimpleTextUtil.write((DataOutput)output, "null", scratch);
            } else {
                SimpleTextUtil.write((DataOutput)output, si.getMinVersion().toString(), scratch);
            }
            SimpleTextUtil.writeNewline((DataOutput)output);
            SimpleTextUtil.write((DataOutput)output, SI_DOCCOUNT);
            SimpleTextUtil.write((DataOutput)output, Integer.toString(si.maxDoc()), scratch);
            SimpleTextUtil.writeNewline((DataOutput)output);
            SimpleTextUtil.write((DataOutput)output, SI_USECOMPOUND);
            SimpleTextUtil.write((DataOutput)output, Boolean.toString(si.getUseCompoundFile()), scratch);
            SimpleTextUtil.writeNewline((DataOutput)output);
            Map diagnostics = si.getDiagnostics();
            int numDiagnostics = diagnostics == null ? 0 : diagnostics.size();
            SimpleTextUtil.write((DataOutput)output, SI_NUM_DIAG);
            SimpleTextUtil.write((DataOutput)output, Integer.toString(numDiagnostics), scratch);
            SimpleTextUtil.writeNewline((DataOutput)output);
            if (numDiagnostics > 0) {
                for (Map.Entry entry : diagnostics.entrySet()) {
                    SimpleTextUtil.write((DataOutput)output, SI_DIAG_KEY);
                    SimpleTextUtil.write((DataOutput)output, (String)entry.getKey(), scratch);
                    SimpleTextUtil.writeNewline((DataOutput)output);
                    SimpleTextUtil.write((DataOutput)output, SI_DIAG_VALUE);
                    SimpleTextUtil.write((DataOutput)output, (String)entry.getValue(), scratch);
                    SimpleTextUtil.writeNewline((DataOutput)output);
                }
            }
            Map attributes = si.getAttributes();
            SimpleTextUtil.write((DataOutput)output, SI_NUM_ATT);
            SimpleTextUtil.write((DataOutput)output, Integer.toString(attributes.size()), scratch);
            SimpleTextUtil.writeNewline((DataOutput)output);
            for (Map.Entry entry : attributes.entrySet()) {
                SimpleTextUtil.write((DataOutput)output, SI_ATT_KEY);
                SimpleTextUtil.write((DataOutput)output, (String)entry.getKey(), scratch);
                SimpleTextUtil.writeNewline((DataOutput)output);
                SimpleTextUtil.write((DataOutput)output, SI_ATT_VALUE);
                SimpleTextUtil.write((DataOutput)output, (String)entry.getValue(), scratch);
                SimpleTextUtil.writeNewline((DataOutput)output);
            }
            Set set = si.files();
            int n = set == null ? 0 : set.size();
            SimpleTextUtil.write((DataOutput)output, SI_NUM_FILES);
            SimpleTextUtil.write((DataOutput)output, Integer.toString(n), scratch);
            SimpleTextUtil.writeNewline((DataOutput)output);
            if (n > 0) {
                for (String fileName : set) {
                    SimpleTextUtil.write((DataOutput)output, SI_FILE);
                    SimpleTextUtil.write((DataOutput)output, fileName, scratch);
                    SimpleTextUtil.writeNewline((DataOutput)output);
                }
            }
            SimpleTextUtil.write((DataOutput)output, SI_ID);
            SimpleTextUtil.write((DataOutput)output, new BytesRef(si.getId()));
            SimpleTextUtil.writeNewline((DataOutput)output);
            Sort indexSort = si.getIndexSort();
            SimpleTextUtil.write((DataOutput)output, SI_SORT);
            int numSortFields = indexSort == null ? 0 : indexSort.getSort().length;
            SimpleTextUtil.write((DataOutput)output, Integer.toString(numSortFields), scratch);
            SimpleTextUtil.writeNewline((DataOutput)output);
            for (int i = 0; i < numSortFields; ++i) {
                SortField sortField = indexSort.getSort()[i];
                IndexSorter sorter = sortField.getIndexSorter();
                if (sorter == null) {
                    throw new IllegalStateException("Cannot serialize sort " + sortField);
                }
                SimpleTextUtil.write((DataOutput)output, SI_SORT_NAME);
                SimpleTextUtil.write((DataOutput)output, sorter.getProviderName(), scratch);
                SimpleTextUtil.writeNewline((DataOutput)output);
                SimpleTextUtil.write((DataOutput)output, SI_SORT_TYPE);
                SimpleTextUtil.write((DataOutput)output, sortField.toString(), scratch);
                SimpleTextUtil.writeNewline((DataOutput)output);
                SimpleTextUtil.write((DataOutput)output, SI_SORT_BYTES);
                BytesRefOutput b = new BytesRefOutput();
                SortFieldProvider.write((SortField)sortField, (DataOutput)b);
                SimpleTextUtil.write((DataOutput)output, b.bytes.get().toString(), scratch);
                SimpleTextUtil.writeNewline((DataOutput)output);
            }
            SimpleTextUtil.writeChecksum(output, scratch);
        }
    }

    static class BytesRefOutput
    extends DataOutput {
        final BytesRefBuilder bytes = new BytesRefBuilder();

        BytesRefOutput() {
        }

        public void writeByte(byte b) {
            this.bytes.append(b);
        }

        public void writeBytes(byte[] b, int offset, int length) {
            this.bytes.append(b, offset, length);
        }
    }
}

