/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.uniformsplit;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.codecs.uniformsplit.BlockDecoder;
import org.apache.lucene.codecs.uniformsplit.FSTDictionary;
import org.apache.lucene.codecs.uniformsplit.FieldMetadata;
import org.apache.lucene.codecs.uniformsplit.IndexDictionary;
import org.apache.lucene.codecs.uniformsplit.RamUsageUtil;
import org.apache.lucene.codecs.uniformsplit.UniformSplitTerms;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;

public class UniformSplitTermsReader
extends FieldsProducer {
    private static final long BASE_RAM_USAGE = RamUsageEstimator.shallowSizeOfInstance(UniformSplitTermsReader.class) + RamUsageEstimator.shallowSizeOfInstance(IndexInput.class) * 2L;
    protected final PostingsReaderBase postingsReader;
    protected final int version;
    protected final IndexInput blockInput;
    protected final IndexInput dictionaryInput;
    protected final Map<String, UniformSplitTerms> fieldToTermsMap;
    protected final Collection<String> sortedFieldNames;

    public UniformSplitTermsReader(PostingsReaderBase postingsReader, SegmentReadState state, BlockDecoder blockDecoder, boolean dictionaryOnHeap) throws IOException {
        this(postingsReader, state, blockDecoder, dictionaryOnHeap, FieldMetadata.Serializer.INSTANCE, "UniformSplit", 0, 1, "ustb", "ustd");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected UniformSplitTermsReader(PostingsReaderBase postingsReader, SegmentReadState state, BlockDecoder blockDecoder, boolean dictionaryOnHeap, FieldMetadata.Serializer fieldMetadataReader, String codecName, int versionStart, int versionCurrent, String termsBlocksExtension, String dictionaryExtension) throws IOException {
        IndexInput dictionaryInput = null;
        IndexInput blockInput = null;
        boolean success = false;
        try {
            this.postingsReader = postingsReader;
            String segmentName = state.segmentInfo.name;
            String termsName = IndexFileNames.segmentFileName((String)segmentName, (String)state.segmentSuffix, (String)termsBlocksExtension);
            blockInput = state.directory.openInput(termsName, state.context);
            this.version = CodecUtil.checkIndexHeader((DataInput)blockInput, (String)codecName, (int)versionStart, (int)versionCurrent, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
            String indexName = IndexFileNames.segmentFileName((String)segmentName, (String)state.segmentSuffix, (String)dictionaryExtension);
            dictionaryInput = state.directory.openInput(indexName, state.context);
            CodecUtil.checkIndexHeader((DataInput)dictionaryInput, (String)codecName, (int)this.version, (int)this.version, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
            CodecUtil.checksumEntireFile((IndexInput)dictionaryInput);
            postingsReader.init(blockInput, state);
            CodecUtil.retrieveChecksum((IndexInput)blockInput);
            this.seekFieldsMetadata(blockInput);
            Collection<FieldMetadata> fieldMetadataCollection = this.readFieldsMetadata(blockInput, blockDecoder, state.fieldInfos, fieldMetadataReader, state.segmentInfo.maxDoc());
            this.fieldToTermsMap = new HashMap<String, UniformSplitTerms>();
            this.blockInput = blockInput;
            this.dictionaryInput = dictionaryInput;
            this.fillFieldMap(postingsReader, state, blockDecoder, dictionaryOnHeap, dictionaryInput, blockInput, fieldMetadataCollection, state.fieldInfos);
            ArrayList<String> fieldNames = new ArrayList<String>(this.fieldToTermsMap.keySet());
            Collections.sort(fieldNames);
            this.sortedFieldNames = Collections.unmodifiableList(fieldNames);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{blockInput, dictionaryInput});
            throw throwable;
        }
    }

    protected void fillFieldMap(PostingsReaderBase postingsReader, SegmentReadState state, BlockDecoder blockDecoder, boolean dictionaryOnHeap, IndexInput dictionaryInput, IndexInput blockInput, Collection<FieldMetadata> fieldMetadataCollection, FieldInfos fieldInfos) throws IOException {
        for (FieldMetadata fieldMetadata : fieldMetadataCollection) {
            IndexDictionary.BrowserSupplier dictionaryBrowserSupplier = this.createDictionaryBrowserSupplier(state, dictionaryInput, fieldMetadata, blockDecoder, dictionaryOnHeap);
            this.fieldToTermsMap.put(fieldMetadata.getFieldInfo().name, new UniformSplitTerms(blockInput, fieldMetadata, postingsReader, blockDecoder, dictionaryBrowserSupplier));
        }
    }

    protected IndexDictionary.BrowserSupplier createDictionaryBrowserSupplier(SegmentReadState state, IndexInput dictionaryInput, FieldMetadata fieldMetadata, BlockDecoder blockDecoder, boolean dictionaryOnHeap) throws IOException {
        return new FSTDictionary.BrowserSupplier(dictionaryInput, fieldMetadata.getDictionaryStartFP(), blockDecoder, dictionaryOnHeap);
    }

    protected Collection<FieldMetadata> readFieldsMetadata(IndexInput indexInput, BlockDecoder blockDecoder, FieldInfos fieldInfos, FieldMetadata.Serializer fieldMetadataReader, int maxNumDocs) throws IOException {
        int numFields = indexInput.readVInt();
        if (numFields < 0) {
            throw new CorruptIndexException("Illegal number of fields= " + numFields, (DataInput)indexInput);
        }
        return blockDecoder != null && this.version >= 1 ? this.readEncodedFieldsMetadata(numFields, (DataInput)indexInput, blockDecoder, fieldInfos, fieldMetadataReader, maxNumDocs) : this.readUnencodedFieldsMetadata(numFields, (DataInput)indexInput, fieldInfos, fieldMetadataReader, maxNumDocs);
    }

    protected Collection<FieldMetadata> readEncodedFieldsMetadata(int numFields, DataInput metadataInput, BlockDecoder blockDecoder, FieldInfos fieldInfos, FieldMetadata.Serializer fieldMetadataReader, int maxNumDocs) throws IOException {
        long encodedLength = metadataInput.readVLong();
        if (encodedLength < 0L) {
            throw new CorruptIndexException("Illegal encoded length: " + encodedLength, metadataInput);
        }
        BytesRef decodedBytes = blockDecoder.decode(metadataInput, encodedLength);
        ByteArrayDataInput decodedMetadataInput = new ByteArrayDataInput(decodedBytes.bytes, 0, decodedBytes.length);
        return this.readUnencodedFieldsMetadata(numFields, (DataInput)decodedMetadataInput, fieldInfos, fieldMetadataReader, maxNumDocs);
    }

    protected Collection<FieldMetadata> readUnencodedFieldsMetadata(int numFields, DataInput metadataInput, FieldInfos fieldInfos, FieldMetadata.Serializer fieldMetadataReader, int maxNumDocs) throws IOException {
        ArrayList<FieldMetadata> fieldMetadataCollection = new ArrayList<FieldMetadata>(numFields);
        for (int i = 0; i < numFields; ++i) {
            fieldMetadataCollection.add(fieldMetadataReader.read(metadataInput, fieldInfos, maxNumDocs));
        }
        return fieldMetadataCollection;
    }

    public void close() throws IOException {
        try {
            IOUtils.close((Closeable[])new Closeable[]{this.blockInput, this.dictionaryInput, this.postingsReader});
        }
        finally {
            this.fieldToTermsMap.clear();
        }
    }

    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile((IndexInput)this.blockInput);
        this.postingsReader.checkIntegrity();
    }

    public Iterator<String> iterator() {
        return this.sortedFieldNames.iterator();
    }

    public Terms terms(String field) {
        return this.fieldToTermsMap.get(field);
    }

    public int size() {
        return this.fieldToTermsMap.size();
    }

    public long ramBytesUsed() {
        long ramUsage = BASE_RAM_USAGE;
        ramUsage += this.postingsReader.ramBytesUsed();
        ramUsage += RamUsageUtil.ramBytesUsedByHashMapOfSize(this.fieldToTermsMap.size());
        ramUsage += this.getTermsRamBytesUsed();
        return ramUsage += RamUsageUtil.ramBytesUsedByUnmodifiableArrayListOfSize(this.sortedFieldNames.size());
    }

    protected long getTermsRamBytesUsed() {
        long ramUsage = 0L;
        for (UniformSplitTerms terms : this.fieldToTermsMap.values()) {
            ramUsage += terms.ramBytesUsed();
        }
        return ramUsage;
    }

    protected void seekFieldsMetadata(IndexInput indexInput) throws IOException {
        indexInput.seek(indexInput.length() - (long)CodecUtil.footerLength() - 8L);
        indexInput.seek(indexInput.readLong());
    }
}

