/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.web;

import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.impl.ContextAnchor;
import org.apache.logging.log4j.core.impl.Log4jContextFactory;
import org.apache.logging.log4j.core.lookup.Interpolator;
import org.apache.logging.log4j.core.lookup.StrLookup;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.core.selector.NamedContextSelector;
import org.apache.logging.log4j.core.util.FileUtils;
import org.apache.logging.log4j.core.util.Loader;
import org.apache.logging.log4j.core.util.NetUtils;
import org.apache.logging.log4j.core.util.SetUtils;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.apache.logging.log4j.web.Log4jWebLifeCycle;

final class Log4jWebInitializerImpl
extends AbstractLifeCycle
implements Log4jWebLifeCycle {
    private static final Object MUTEX = new Object();
    private final Map<String, String> map = new ConcurrentHashMap<String, String>();
    private final StrSubstitutor substitutor = new StrSubstitutor((StrLookup)new Interpolator(this.map));
    private final ServletContext servletContext;
    private String name;
    private NamedContextSelector namedContextSelector;
    private LoggerContext loggerContext;

    private Log4jWebInitializerImpl(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.map.put("hostName", NetUtils.getLocalHostname());
    }

    @Override
    public synchronized void start() {
        if (this.isStopped() || this.isStopping()) {
            throw new IllegalStateException("Cannot start this Log4jWebInitializerImpl after it was stopped.");
        }
        if (this.isInitialized()) {
            super.setStarting();
            this.name = this.substitutor.replace(this.servletContext.getInitParameter("log4jContextName"));
            String location = this.substitutor.replace(this.servletContext.getInitParameter("log4jConfiguration"));
            boolean isJndi = "true".equalsIgnoreCase(this.servletContext.getInitParameter("isLog4jContextSelectorNamed"));
            if (isJndi) {
                this.initializeJndi(location);
            } else {
                this.initializeNonJndi(location);
            }
            this.servletContext.setAttribute(CONTEXT_ATTRIBUTE, (Object)this.loggerContext);
            super.setStarted();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initializeJndi(String location) {
        URI configLocation = this.getConfigURI(location);
        if (this.name == null) {
            throw new IllegalStateException("A log4jContextName context parameter is required");
        }
        LoggerContextFactory factory = LogManager.getFactory();
        if (!(factory instanceof Log4jContextFactory)) {
            this.servletContext.log("Potential problem: Factory is not an instance of Log4jContextFactory.");
            return;
        }
        ContextSelector selector = ((Log4jContextFactory)factory).getSelector();
        if (!(selector instanceof NamedContextSelector)) {
            this.servletContext.log("Potential problem: Selector is not an instance of NamedContextSelector.");
            return;
        }
        this.namedContextSelector = (NamedContextSelector)selector;
        LoggerContext context = this.namedContextSelector.locateContext(this.name, (Object)this.servletContext, configLocation);
        ContextAnchor.THREAD_CONTEXT.set(context);
        if (context.isInitialized()) {
            context.start();
        }
        ContextAnchor.THREAD_CONTEXT.remove();
        this.loggerContext = context;
        this.servletContext.log("Created logger context for [" + this.name + "] using [" + context.getClass().getClassLoader() + "].");
    }

    private void initializeNonJndi(String location) {
        if (this.name == null) {
            this.name = this.servletContext.getServletContextName();
        }
        if (this.name == null && location == null) {
            this.servletContext.log("No Log4j context configuration provided. This is very unusual.");
            return;
        }
        URI uri = this.getConfigURI(location);
        this.loggerContext = Configurator.initialize((String)this.name, (ClassLoader)this.getClassLoader(), (URI)uri, (Object)this.servletContext);
    }

    private URI getConfigURI(String location) {
        try {
            URL url;
            String configLocation = location;
            if (configLocation == null) {
                String[] paths = SetUtils.prefixSet((Set)this.servletContext.getResourcePaths("/WEB-INF/"), (String)"/WEB-INF/log4j2");
                if (paths.length == 1) {
                    configLocation = paths[0];
                } else if (paths.length > 1) {
                    String prefix = "/WEB-INF/log4j2-" + this.name + ".";
                    boolean found = false;
                    for (String str : paths) {
                        if (!str.startsWith(prefix)) continue;
                        configLocation = str;
                        break;
                    }
                    if (!found) {
                        configLocation = paths[0];
                    }
                }
            }
            if (configLocation != null && (url = this.servletContext.getResource(configLocation)) != null) {
                return url.toURI();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (location != null) {
            try {
                return FileUtils.getCorrectedFilePathUri((String)location);
            }
            catch (Exception e) {
                this.servletContext.log("Unable to convert configuration location [" + location + "] to a URI!", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public synchronized void stop() {
        if (!this.isStarted() && !this.isStopped()) {
            throw new IllegalStateException("Cannot stop this Log4jWebInitializer because it has not started.");
        }
        if (this.isStarted()) {
            this.setStopping();
            if (this.loggerContext != null) {
                this.servletContext.log("Removing LoggerContext for [" + this.name + "].");
                this.servletContext.removeAttribute(CONTEXT_ATTRIBUTE);
                if (this.namedContextSelector != null) {
                    this.namedContextSelector.removeContext(this.name);
                }
                this.loggerContext.stop();
                this.loggerContext.setExternalContext(null);
                this.loggerContext = null;
            }
            this.setStopped();
        }
    }

    @Override
    public void setLoggerContext() {
        if (this.loggerContext != null) {
            ContextAnchor.THREAD_CONTEXT.set(this.loggerContext);
        }
    }

    @Override
    public void clearLoggerContext() {
        ContextAnchor.THREAD_CONTEXT.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wrapExecution(Runnable runnable) {
        this.setLoggerContext();
        try {
            runnable.run();
        }
        finally {
            this.clearLoggerContext();
        }
    }

    private ClassLoader getClassLoader() {
        try {
            return this.servletContext.getClassLoader();
        }
        catch (Throwable ignore) {
            return Log4jWebInitializerImpl.class.getClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Log4jWebLifeCycle getLog4jWebInitializer(ServletContext servletContext) {
        Object object = MUTEX;
        synchronized (object) {
            Log4jWebLifeCycle initializer = (Log4jWebLifeCycle)servletContext.getAttribute(SUPPORT_ATTRIBUTE);
            if (initializer == null) {
                initializer = new Log4jWebInitializerImpl(servletContext);
                servletContext.setAttribute(SUPPORT_ATTRIBUTE, (Object)initializer);
            }
            return initializer;
        }
    }

    static {
        if (Loader.isClassAvailable((String)"org.apache.logging.log4j.core.web.JNDIContextFilter")) {
            throw new IllegalStateException("You are using Log4j 2 in a web application with the old, extinct log4j-web artifact. This is not supported and could cause serious runtime problems. Pleaseremove the log4j-web JAR file from your application.");
        }
    }
}

