/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.resolver;

import java.util.function.Supplier;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolverContext;
import org.apache.logging.log4j.layout.template.json.resolver.StackTraceResolver;
import org.apache.logging.log4j.layout.template.json.util.JsonWriter;
import org.apache.logging.log4j.layout.template.json.util.Recycler;
import org.apache.logging.log4j.layout.template.json.util.TruncatingBufferedPrintWriter;

final class StackTraceStringResolver
implements StackTraceResolver {
    private final Recycler<TruncatingBufferedPrintWriter> writerRecycler;

    StackTraceStringResolver(EventResolverContext context) {
        Supplier<TruncatingBufferedPrintWriter> writerSupplier = () -> TruncatingBufferedPrintWriter.ofCapacity(context.getMaxStringByteCount());
        this.writerRecycler = context.getRecyclerFactory().create(writerSupplier, TruncatingBufferedPrintWriter::close);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resolve(Throwable throwable, JsonWriter jsonWriter) {
        TruncatingBufferedPrintWriter writer = this.writerRecycler.acquire();
        try {
            throwable.printStackTrace(writer);
            jsonWriter.writeString(writer.getBuffer(), 0, writer.getPosition());
        }
        finally {
            this.writerRecycler.release(writer);
        }
    }
}

