/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.resolver;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.layout.template.json.resolver.EndOfBatchResolverFactory;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolverContext;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolverFactory;
import org.apache.logging.log4j.layout.template.json.resolver.ExceptionResolverFactory;
import org.apache.logging.log4j.layout.template.json.resolver.ExceptionRootCauseResolverFactory;
import org.apache.logging.log4j.layout.template.json.resolver.LevelResolverFactory;
import org.apache.logging.log4j.layout.template.json.resolver.LoggerResolverFactory;
import org.apache.logging.log4j.layout.template.json.resolver.MainMapResolverFactory;
import org.apache.logging.log4j.layout.template.json.resolver.MapResolverFactory;
import org.apache.logging.log4j.layout.template.json.resolver.MarkerResolverFactory;
import org.apache.logging.log4j.layout.template.json.resolver.MessageParameterResolverFactory;
import org.apache.logging.log4j.layout.template.json.resolver.MessageResolverFactory;
import org.apache.logging.log4j.layout.template.json.resolver.PatternResolverFactory;
import org.apache.logging.log4j.layout.template.json.resolver.SourceResolverFactory;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolver;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolverFactory;
import org.apache.logging.log4j.layout.template.json.resolver.ThreadContextDataResolverFactory;
import org.apache.logging.log4j.layout.template.json.resolver.ThreadContextStackResolverFactory;
import org.apache.logging.log4j.layout.template.json.resolver.ThreadResolverFactory;
import org.apache.logging.log4j.layout.template.json.resolver.TimestampResolverFactory;

enum EventResolverFactories {

    private static final Map<String, TemplateResolverFactory<LogEvent, EventResolverContext, ? extends TemplateResolver<LogEvent>>> RESOLVER_FACTORY_BY_NAME = EventResolverFactories.createResolverFactoryByName();

    private static Map<String, TemplateResolverFactory<LogEvent, EventResolverContext, ? extends TemplateResolver<LogEvent>>> createResolverFactoryByName() {
        List<EventResolverFactory> resolverFactories = Arrays.asList(ThreadContextDataResolverFactory.getInstance(), ThreadContextStackResolverFactory.getInstance(), EndOfBatchResolverFactory.getInstance(), ExceptionResolverFactory.getInstance(), ExceptionRootCauseResolverFactory.getInstance(), LevelResolverFactory.getInstance(), LoggerResolverFactory.getInstance(), MainMapResolverFactory.getInstance(), MapResolverFactory.getInstance(), MarkerResolverFactory.getInstance(), MessageResolverFactory.getInstance(), MessageParameterResolverFactory.getInstance(), PatternResolverFactory.getInstance(), SourceResolverFactory.getInstance(), ThreadResolverFactory.getInstance(), TimestampResolverFactory.getInstance());
        LinkedHashMap<String, EventResolverFactory> resolverFactoryByName = new LinkedHashMap<String, EventResolverFactory>();
        for (EventResolverFactory resolverFactory : resolverFactories) {
            resolverFactoryByName.put(resolverFactory.getName(), resolverFactory);
        }
        return Collections.unmodifiableMap(resolverFactoryByName);
    }

    static Map<String, TemplateResolverFactory<LogEvent, EventResolverContext, ? extends TemplateResolver<LogEvent>>> getResolverFactoryByName() {
        return RESOLVER_FACTORY_BY_NAME;
    }
}

