/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.kubernetes;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.net.URL;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.lookup.AbstractLookup;
import org.apache.logging.log4j.kubernetes.ContainerUtil;
import org.apache.logging.log4j.kubernetes.KubernetesClientBuilder;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="k8s", category="Lookup")
public class KubernetesLookup
extends AbstractLookup {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final String HOSTNAME = "HOSTNAME";
    private static final String SPRING_ENVIRONMENT_KEY = "SpringEnvironment";
    private static volatile KubernetesInfo kubernetesInfo;
    private static Lock initLock;
    private static boolean isSpringIncluded;
    private Pod pod;
    private Namespace namespace;
    private URL masterUrl;

    public KubernetesLookup() {
        this.pod = null;
        this.namespace = null;
        this.masterUrl = null;
        this.initialize();
    }

    KubernetesLookup(Pod pod, Namespace namespace, URL masterUrl) {
        this.pod = pod;
        this.namespace = namespace;
        this.masterUrl = masterUrl;
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initialize() {
        if (kubernetesInfo == null || isSpringIncluded && !KubernetesLookup.kubernetesInfo.isSpringActive) {
            initLock.lock();
            boolean isSpringActive = this.isSpringActive();
            if (kubernetesInfo == null || !KubernetesLookup.kubernetesInfo.isSpringActive && isSpringActive) {
                try {
                    KubernetesInfo info = new KubernetesInfo();
                    KubernetesClient client = null;
                    info.isSpringActive = isSpringActive;
                    if (this.pod == null) {
                        client = new KubernetesClientBuilder().createClient();
                        if (client != null) {
                            this.pod = this.getCurrentPod(System.getenv(HOSTNAME), client);
                            info.masterUrl = client.getMasterUrl();
                            if (this.pod != null) {
                                info.namespace = this.pod.getMetadata().getNamespace();
                                this.namespace = this.namespace = (Namespace)((Resource)client.namespaces().withName(info.namespace)).get();
                            }
                        } else {
                            LOGGER.warn("Kubernetes is not available for access");
                        }
                    } else {
                        info.masterUrl = this.masterUrl;
                    }
                    if (this.pod != null) {
                        String containerName;
                        String containerId;
                        if (this.namespace != null) {
                            info.namespaceId = this.namespace.getMetadata().getUid();
                            info.namespaceAnnotations = this.namespace.getMetadata().getAnnotations();
                            info.namespaceLabels = this.namespace.getMetadata().getLabels();
                        }
                        info.app = (String)this.pod.getMetadata().getLabels().get("app");
                        info.hostName = this.pod.getSpec().getNodeName();
                        info.annotations = this.pod.getMetadata().getAnnotations();
                        String app = info.app != null ? info.app : "";
                        info.podTemplateHash = (String)this.pod.getMetadata().getLabels().get("pod-template-hash");
                        info.accountName = this.pod.getSpec().getServiceAccountName();
                        info.clusterName = this.pod.getMetadata().getClusterName();
                        info.hostIp = this.pod.getStatus().getHostIP();
                        info.labels = this.pod.getMetadata().getLabels();
                        info.podId = this.pod.getMetadata().getUid();
                        info.podIp = this.pod.getStatus().getPodIP();
                        info.podName = this.pod.getMetadata().getName();
                        ContainerStatus containerStatus = null;
                        List statuses = this.pod.getStatus().getContainerStatuses();
                        if (statuses.size() == 1) {
                            containerStatus = (ContainerStatus)statuses.get(0);
                        } else if (statuses.size() > 1 && (containerId = ContainerUtil.getContainerId()) != null) {
                            containerStatus = statuses.stream().filter(cs -> cs.getContainerID().contains(containerId)).findFirst().orElse(null);
                        }
                        if (containerStatus != null) {
                            info.containerId = containerStatus.getContainerID();
                            info.imageId = containerStatus.getImageID();
                            containerName = containerStatus.getName();
                        } else {
                            containerName = null;
                        }
                        Container container = null;
                        List containers = this.pod.getSpec().getContainers();
                        if (containers.size() == 1) {
                            container = (Container)containers.get(0);
                        } else if (containers.size() > 1 && containerName != null) {
                            container = containers.stream().filter(c -> c.getName().equals(containerName)).findFirst().orElse(null);
                        }
                        if (container != null) {
                            info.containerName = container.getName();
                            info.imageName = container.getImage();
                        }
                        kubernetesInfo = info;
                    }
                }
                finally {
                    initLock.unlock();
                }
            }
        }
        return kubernetesInfo != null;
    }

    public String lookup(LogEvent event, String key) {
        if (kubernetesInfo == null) {
            return null;
        }
        switch (key) {
            case "accountName": {
                return KubernetesLookup.kubernetesInfo.accountName;
            }
            case "annotations": {
                return KubernetesLookup.kubernetesInfo.annotations.toString();
            }
            case "containerId": {
                return KubernetesLookup.kubernetesInfo.containerId;
            }
            case "containerName": {
                return KubernetesLookup.kubernetesInfo.containerName;
            }
            case "clusterName": {
                return KubernetesLookup.kubernetesInfo.clusterName;
            }
            case "host": {
                return KubernetesLookup.kubernetesInfo.hostName;
            }
            case "hostIp": {
                return KubernetesLookup.kubernetesInfo.hostIp;
            }
            case "labels": {
                return KubernetesLookup.kubernetesInfo.labels.toString();
            }
            case "labels.app": {
                return KubernetesLookup.kubernetesInfo.app;
            }
            case "labels.podTemplateHash": {
                return KubernetesLookup.kubernetesInfo.podTemplateHash;
            }
            case "masterUrl": {
                return KubernetesLookup.kubernetesInfo.masterUrl.toString();
            }
            case "namespaceAnnotations": {
                return KubernetesLookup.kubernetesInfo.namespaceAnnotations.toString();
            }
            case "namespaceId": {
                return KubernetesLookup.kubernetesInfo.namespaceId;
            }
            case "namespaceLabels": {
                return KubernetesLookup.kubernetesInfo.namespaceLabels.toString();
            }
            case "namespaceName": {
                return KubernetesLookup.kubernetesInfo.namespace;
            }
            case "podId": {
                return KubernetesLookup.kubernetesInfo.podId;
            }
            case "podIp": {
                return KubernetesLookup.kubernetesInfo.podIp;
            }
            case "podName": {
                return KubernetesLookup.kubernetesInfo.podName;
            }
            case "imageId": {
                return KubernetesLookup.kubernetesInfo.imageId;
            }
            case "imageName": {
                return KubernetesLookup.kubernetesInfo.imageName;
            }
        }
        return null;
    }

    void clearInfo() {
        kubernetesInfo = null;
    }

    private String getHostname() {
        return System.getenv(HOSTNAME);
    }

    private Pod getCurrentPod(String hostName, KubernetesClient kubernetesClient) {
        try {
            if (this.isServiceAccount() && Strings.isNotBlank((String)hostName)) {
                return (Pod)((PodResource)kubernetesClient.pods().withName(hostName)).get();
            }
        }
        catch (Throwable t) {
            LOGGER.debug("Unable to locate pod with name {}.", (Object)hostName);
        }
        return null;
    }

    private boolean isServiceAccount() {
        return Paths.get("/var/run/secrets/kubernetes.io/serviceaccount/token", new String[0]).toFile().exists() && Paths.get("/var/run/secrets/kubernetes.io/serviceaccount/ca.crt", new String[0]).toFile().exists();
    }

    private boolean isSpringActive() {
        return isSpringIncluded && LogManager.getFactory() != null && LogManager.getFactory().hasContext(KubernetesLookup.class.getName(), null, false) && LogManager.getContext((boolean)false).getObject(SPRING_ENVIRONMENT_KEY) != null;
    }

    static {
        initLock = new ReentrantLock();
        isSpringIncluded = LoaderUtil.isClassAvailable((String)"org.apache.logging.log4j.spring.cloud.config.client.SpringEnvironmentHolder");
    }

    private static class KubernetesInfo {
        boolean isSpringActive;
        String accountName;
        Map<String, String> annotations;
        String app;
        String clusterName;
        String containerId;
        String containerName;
        String hostName;
        String hostIp;
        String imageId;
        String imageName;
        Map<String, String> labels;
        URL masterUrl;
        String namespace;
        Map<String, String> namespaceAnnotations;
        String namespaceId;
        Map<String, String> namespaceLabels;
        String podId;
        String podIp;
        String podName;
        String podTemplateHash;

        private KubernetesInfo() {
        }
    }
}

