/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.kubernetes;

import io.fabric8.kubernetes.client.Config;
import java.time.Duration;
import org.apache.logging.log4j.util.PropertiesUtil;

public class KubernetesClientProperties {
    private static final String[] PREFIXES = new String[]{"log4j2.kubernetes.client.", "spring.cloud.kubernetes.client."};
    private static final String API_VERSION = "apiVersion";
    private static final String CA_CERT_FILE = "caCertFile";
    private static final String CA_CERT_DATA = "caCertData";
    private static final String CLIENT_CERT_FILE = "clientCertFile";
    private static final String CLIENT_CERT_DATA = "clientCertData";
    private static final String CLIENT_KEY_FILE = "clientKeyFile";
    private static final String CLIENT_KEY_DATA = "cientKeyData";
    private static final String CLIENT_KEY_ALGO = "clientKeyAlgo";
    private static final String CLIENT_KEY_PASSPHRASE = "clientKeyPassphrase";
    private static final String CONNECTION_TIMEOUT = "connectionTimeout";
    private static final String HTTP_PROXY = "httpProxy";
    private static final String HTTPS_PROXY = "httpsProxy";
    private static final String LOGGING_INTERVAL = "loggingInterval";
    private static final String MASTER_URL = "masterUrl";
    private static final String NAMESPACE = "namespace";
    private static final String NO_PROXY = "noProxy";
    private static final String PASSWORD = "password";
    private static final String PROXY_USERNAME = "proxyUsername";
    private static final String PROXY_PASSWORD = "proxyPassword";
    private static final String REQUEST_TIMEOUT = "requestTimeout";
    private static final String ROLLING_TIMEOUT = "rollingTimeout";
    private static final String TRUST_CERTS = "trustCerts";
    private static final String USERNAME = "username";
    private static final String WATCH_RECONNECT_INTERVAL = "watchReconnectInterval";
    private static final String WATCH_RECONNECT_LIMIT = "watchReconnectLimit";
    private PropertiesUtil props = PropertiesUtil.getProperties();
    private final Config base;

    public KubernetesClientProperties(Config base) {
        this.base = base;
    }

    public String getApiVersion() {
        return this.props.getStringProperty(PREFIXES, API_VERSION, () -> ((Config)this.base).getApiVersion());
    }

    public String getCaCertFile() {
        return this.props.getStringProperty(PREFIXES, CA_CERT_FILE, () -> ((Config)this.base).getCaCertFile());
    }

    public String getCaCertData() {
        return this.props.getStringProperty(PREFIXES, CA_CERT_DATA, () -> ((Config)this.base).getCaCertData());
    }

    public String getClientCertFile() {
        return this.props.getStringProperty(PREFIXES, CLIENT_CERT_FILE, () -> ((Config)this.base).getClientCertFile());
    }

    public String getClientCertData() {
        return this.props.getStringProperty(PREFIXES, CLIENT_CERT_DATA, () -> ((Config)this.base).getClientCertData());
    }

    public String getClientKeyFile() {
        return this.props.getStringProperty(PREFIXES, CLIENT_KEY_FILE, () -> ((Config)this.base).getClientKeyFile());
    }

    public String getClientKeyData() {
        return this.props.getStringProperty(PREFIXES, CLIENT_KEY_DATA, () -> ((Config)this.base).getClientKeyData());
    }

    public String getClientKeyAlgo() {
        return this.props.getStringProperty(PREFIXES, CLIENT_KEY_ALGO, () -> ((Config)this.base).getClientKeyAlgo());
    }

    public String getClientKeyPassphrase() {
        return this.props.getStringProperty(PREFIXES, CLIENT_KEY_PASSPHRASE, () -> ((Config)this.base).getClientKeyPassphrase());
    }

    public int getConnectionTimeout() {
        Duration timeout = this.props.getDurationProperty(PREFIXES, CONNECTION_TIMEOUT, null);
        if (timeout != null) {
            return (int)timeout.toMillis();
        }
        return this.base.getConnectionTimeout();
    }

    public String getHttpProxy() {
        return this.props.getStringProperty(PREFIXES, HTTP_PROXY, () -> ((Config)this.base).getHttpProxy());
    }

    public String getHttpsProxy() {
        return this.props.getStringProperty(PREFIXES, HTTPS_PROXY, () -> ((Config)this.base).getHttpsProxy());
    }

    public int getLoggingInterval() {
        Duration interval = this.props.getDurationProperty(PREFIXES, LOGGING_INTERVAL, null);
        if (interval != null) {
            return (int)interval.toMillis();
        }
        return this.base.getLoggingInterval();
    }

    public String getMasterUrl() {
        return this.props.getStringProperty(PREFIXES, MASTER_URL, () -> ((Config)this.base).getMasterUrl());
    }

    public String getNamespace() {
        return this.props.getStringProperty(PREFIXES, NAMESPACE, () -> ((Config)this.base).getNamespace());
    }

    public String[] getNoProxy() {
        String result = this.props.getStringProperty(PREFIXES, NO_PROXY, null);
        if (result != null) {
            return result.replace("\\s", "").split(",");
        }
        return this.base.getNoProxy();
    }

    public String getPassword() {
        return this.props.getStringProperty(PREFIXES, PASSWORD, () -> ((Config)this.base).getPassword());
    }

    public String getProxyUsername() {
        return this.props.getStringProperty(PREFIXES, PROXY_USERNAME, () -> ((Config)this.base).getProxyUsername());
    }

    public String getProxyPassword() {
        return this.props.getStringProperty(PREFIXES, PROXY_PASSWORD, () -> ((Config)this.base).getProxyPassword());
    }

    public int getRequestTimeout() {
        Duration interval = this.props.getDurationProperty(PREFIXES, REQUEST_TIMEOUT, null);
        if (interval != null) {
            return (int)interval.toMillis();
        }
        return this.base.getRequestTimeout();
    }

    public long getRollingTimeout() {
        Duration interval = this.props.getDurationProperty(PREFIXES, ROLLING_TIMEOUT, null);
        if (interval != null) {
            return interval.toMillis();
        }
        return this.base.getRollingTimeout();
    }

    public Boolean isTrustCerts() {
        return this.props.getBooleanProperty(PREFIXES, TRUST_CERTS, () -> ((Config)this.base).isTrustCerts());
    }

    public String getUsername() {
        return this.props.getStringProperty(PREFIXES, USERNAME, () -> ((Config)this.base).getUsername());
    }

    public int getWatchReconnectInterval() {
        Duration interval = this.props.getDurationProperty(PREFIXES, WATCH_RECONNECT_INTERVAL, null);
        if (interval != null) {
            return (int)interval.toMillis();
        }
        return this.base.getWatchReconnectInterval();
    }

    public int getWatchReconnectLimit() {
        Duration interval = this.props.getDurationProperty(PREFIXES, WATCH_RECONNECT_LIMIT, null);
        if (interval != null) {
            return (int)interval.toMillis();
        }
        return this.base.getWatchReconnectLimit();
    }
}

