/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.util.Cast;
import org.apache.logging.log4j.util.InternalApi;
import org.apache.logging.log4j.util.Lazy;
import org.apache.logging.log4j.util.LowLevelLogUtil;
import org.apache.logging.log4j.util.ServiceLoaderUtil;

@InternalApi
public class ServiceRegistry {
    private static final Lazy<ServiceRegistry> INSTANCE = Lazy.relaxed(ServiceRegistry::new);
    private final Map<Class<?>, List<?>> mainServices = new ConcurrentHashMap();
    private final Map<Long, Map<Class<?>, List<?>>> bundleServices = new ConcurrentHashMap();

    public static ServiceRegistry getInstance() {
        return INSTANCE.get();
    }

    private ServiceRegistry() {
    }

    public <S> List<S> getServices(Class<S> serviceType, MethodHandles.Lookup lookup, Predicate<S> validator) {
        return this.getServices(serviceType, lookup, validator, true);
    }

    <S> List<S> getServices(Class<S> serviceType, MethodHandles.Lookup lookup, Predicate<S> validator, boolean verbose) {
        List<S> services = this.getMainServices(serviceType, lookup, validator, verbose);
        return Stream.concat(services.stream(), this.bundleServices.values().stream().flatMap(map -> {
            Stream<Object> stream = map.getOrDefault(serviceType, List.of()).stream().map(serviceType::cast);
            return validator != null ? stream.filter(validator) : stream;
        })).distinct().collect(Collectors.toCollection(ArrayList::new));
    }

    <S> List<S> getMainServices(Class<S> serviceType, MethodHandles.Lookup lookup, Predicate<S> validator, boolean verbose) {
        List<?> existing = this.mainServices.get(serviceType);
        if (existing != null) {
            return (List)Cast.cast(existing);
        }
        List services = ServiceLoaderUtil.loadServices(serviceType, lookup, false, verbose).filter(validator != null ? validator : unused -> true).collect(Collectors.toList());
        List oldValue = (List)Cast.cast(this.mainServices.putIfAbsent(serviceType, services));
        return oldValue != null ? oldValue : services;
    }

    public <S> void loadServicesFromBundle(Class<S> serviceType, long bundleId, ClassLoader bundleClassLoader) {
        ArrayList<S> services = new ArrayList<S>();
        try {
            ServiceLoader<S> serviceLoader = ServiceLoader.load(serviceType, bundleClassLoader);
            Iterator<S> iterator = serviceLoader.iterator();
            while (iterator.hasNext()) {
                try {
                    services.add(iterator.next());
                }
                catch (ServiceConfigurationError sce) {
                    String message = String.format("Unable to load %s service in bundle id %d", serviceType.getName(), bundleId);
                    LowLevelLogUtil.logException(message, sce);
                }
            }
        }
        catch (ServiceConfigurationError e) {
            String message = String.format("Unable to load any %s services in bundle id %d", serviceType.getName(), bundleId);
            LowLevelLogUtil.logException(message, e);
        }
        this.registerBundleServices(serviceType, bundleId, services);
    }

    public <S> void registerBundleServices(Class<S> serviceType, long bundleId, List<S> services) {
        List currentServices = (List)Cast.cast(this.bundleServices.computeIfAbsent(bundleId, ignored -> new ConcurrentHashMap()).computeIfAbsent(serviceType, ignored -> new ArrayList()));
        currentServices.addAll(services);
    }

    public void unregisterBundleServices(long bundleId) {
        this.bundleServices.remove(bundleId);
    }
}

