/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.test.junit;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class ExtensionContextAnchor
implements BeforeAllCallback,
BeforeEachCallback,
AfterAllCallback,
AfterEachCallback {
    public static ExtensionContext.Namespace LOG4J2_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{"org.apache.logging.log4j.junit"});
    private static final ThreadLocal<ExtensionContext> EXTENSION_CONTEXT = new InheritableThreadLocal<ExtensionContext>();

    private static void bind(ExtensionContext context) {
        EXTENSION_CONTEXT.set(context);
    }

    private static void unbind(ExtensionContext context) {
        EXTENSION_CONTEXT.set(context.getParent().orElse(null));
    }

    public static ExtensionContext getContext() {
        return EXTENSION_CONTEXT.get();
    }

    public static ExtensionContext getContext(ExtensionContext context) {
        return context != null ? context : EXTENSION_CONTEXT.get();
    }

    static <T> T getAttribute(Object key, Class<T> clazz, ExtensionContext context) {
        ExtensionContext actualContext = ExtensionContextAnchor.getContext(context);
        Assertions.assertNotNull((Object)actualContext, (String)"missing ExtensionContext");
        return (T)actualContext.getStore(LOG4J2_NAMESPACE).get(key, clazz);
    }

    static void setAttribute(Object key, Object value, ExtensionContext context) {
        ExtensionContext actualContext = ExtensionContextAnchor.getContext(context);
        Assertions.assertNotNull((Object)actualContext, (String)"missing ExtensionContext");
        actualContext.getStore(LOG4J2_NAMESPACE).put(key, value);
    }

    static void removeAttribute(Object key, ExtensionContext context) {
        ExtensionContext actualContext = ExtensionContextAnchor.getContext(context);
        if (actualContext != null) {
            actualContext.getStore(LOG4J2_NAMESPACE).remove(key);
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        ExtensionContextAnchor.unbind(context);
    }

    public void afterAll(ExtensionContext context) throws Exception {
        ExtensionContextAnchor.unbind(context);
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        ExtensionContextAnchor.bind(context);
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        ExtensionContextAnchor.bind(context);
    }
}

