/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.client.http;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.livy.client.common.ClientConf;

class HttpConf
extends ClientConf<HttpConf> {
    private static final String HTTP_CONF_PREFIX = "livy.client.http.";
    private static final Map<String, ClientConf.DeprecatedConf> configsWithAlternatives = Collections.unmodifiableMap(new HashMap<String, ClientConf.DeprecatedConf>(){
        {
            this.put(Entry.JOB_INITIAL_POLL_INTERVAL.key, DepConf.JOB_INITIAL_POLL_INTERVAL);
            this.put(Entry.JOB_MAX_POLL_INTERVAL.key, DepConf.JOB_MAX_POLL_INTERVAL);
        }
    });
    private static final Map<String, ClientConf.DeprecatedConf> deprecatedConfigs = Collections.unmodifiableMap(new HashMap());

    HttpConf(Properties config) {
        super(config);
        if (this.getBoolean(Entry.SPNEGO_ENABLED)) {
            if (this.get(Entry.AUTH_LOGIN_CONFIG) == null) {
                throw new IllegalArgumentException(Entry.AUTH_LOGIN_CONFIG.key + " should not be null");
            }
            if (this.get(Entry.KRB5_CONF) == null) {
                throw new IllegalArgumentException(Entry.KRB5_CONF.key + " should not be null");
            }
            System.setProperty("java.security.auth.login.config", this.get(Entry.AUTH_LOGIN_CONFIG));
            System.setProperty("java.security.krb5.conf", this.get(Entry.KRB5_CONF));
            System.setProperty("sun.security.krb5.debug", String.valueOf(this.getBoolean(Entry.KRB5_DEBUG_ENABLED)));
            System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
        }
    }

    boolean isSpnegoEnabled() {
        return this.getBoolean(Entry.SPNEGO_ENABLED);
    }

    @Override
    protected Map<String, ClientConf.DeprecatedConf> getConfigsWithAlternatives() {
        return configsWithAlternatives;
    }

    @Override
    protected Map<String, ClientConf.DeprecatedConf> getDeprecatedConfigs() {
        return deprecatedConfigs;
    }

    static enum DepConf implements ClientConf.DeprecatedConf
    {
        JOB_INITIAL_POLL_INTERVAL("job.initial_poll_interval", "0.4"),
        JOB_MAX_POLL_INTERVAL("job.max_poll_interval", "0.4");

        private final String key;
        private final String version;
        private final String deprecationMessage;

        private DepConf(String key, String version) {
            this(key, version, "");
        }

        private DepConf(String key, String version, String deprecationMessage) {
            this.key = HttpConf.HTTP_CONF_PREFIX + key;
            this.version = version;
            this.deprecationMessage = deprecationMessage;
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public String version() {
            return this.version;
        }

        @Override
        public String deprecationMessage() {
            return this.deprecationMessage;
        }
    }

    static enum Entry implements ClientConf.ConfEntry
    {
        CONNECTION_TIMEOUT("connection.timeout", "10s"),
        CONNECTION_IDLE_TIMEOUT("connection.idle.timeout", "10m"),
        SOCKET_TIMEOUT("connection.socket.timeout", "5m"),
        JOB_INITIAL_POLL_INTERVAL("job.initial-poll-interval", "100ms"),
        JOB_MAX_POLL_INTERVAL("job.max-poll-interval", "5s"),
        CONTENT_COMPRESS_ENABLE("content.compress.enable", true),
        SPNEGO_ENABLED("spnego.enable", false),
        AUTH_LOGIN_CONFIG("auth.login.config", null),
        KRB5_DEBUG_ENABLED("krb5.debug", false),
        KRB5_CONF("krb5.conf", null);

        private final String key;
        private final Object dflt;

        private Entry(String key, Object dflt) {
            this.key = HttpConf.HTTP_CONF_PREFIX + key;
            this.dflt = dflt;
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public Object dflt() {
            return this.dflt;
        }
    }
}

