/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.shaded.apache.http.impl.entity;

import org.apache.livy.shaded.apache.http.HttpException;
import org.apache.livy.shaded.apache.http.HttpMessage;
import org.apache.livy.shaded.apache.http.ProtocolException;
import org.apache.livy.shaded.apache.http.annotation.Immutable;
import org.apache.livy.shaded.apache.http.entity.ContentLengthStrategy;
import org.apache.livy.shaded.apache.http.impl.entity.LaxContentLengthStrategy;

@Immutable
public class DisallowIdentityContentLengthStrategy
implements ContentLengthStrategy {
    public static final DisallowIdentityContentLengthStrategy INSTANCE = new DisallowIdentityContentLengthStrategy(new LaxContentLengthStrategy(0));
    private final ContentLengthStrategy contentLengthStrategy;

    public DisallowIdentityContentLengthStrategy(ContentLengthStrategy contentLengthStrategy) {
        this.contentLengthStrategy = contentLengthStrategy;
    }

    @Override
    public long determineLength(HttpMessage message) throws HttpException {
        long result = this.contentLengthStrategy.determineLength(message);
        if (result == -1L) {
            throw new ProtocolException("Identity transfer encoding cannot be used");
        }
        return result;
    }
}

