/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.shaded.apache.http.client.protocol;

import java.io.IOException;
import org.apache.livy.shaded.apache.http.HttpEntity;
import org.apache.livy.shaded.apache.http.HttpEntityEnclosingRequest;
import org.apache.livy.shaded.apache.http.HttpException;
import org.apache.livy.shaded.apache.http.HttpRequest;
import org.apache.livy.shaded.apache.http.HttpRequestInterceptor;
import org.apache.livy.shaded.apache.http.HttpVersion;
import org.apache.livy.shaded.apache.http.ProtocolVersion;
import org.apache.livy.shaded.apache.http.annotation.Contract;
import org.apache.livy.shaded.apache.http.annotation.ThreadingBehavior;
import org.apache.livy.shaded.apache.http.client.config.RequestConfig;
import org.apache.livy.shaded.apache.http.client.protocol.HttpClientContext;
import org.apache.livy.shaded.apache.http.protocol.HttpContext;
import org.apache.livy.shaded.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

