/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server.user;

import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.lens.server.user.CustomUserConfigLoader;
import org.apache.lens.server.user.DatabaseUserConfigLoader;
import org.apache.lens.server.user.FixedUserConfigLoader;
import org.apache.lens.server.user.LDAPBackedDatabaseUserConfigLoader;
import org.apache.lens.server.user.PropertyBasedUserConfigLoader;
import org.apache.lens.server.user.UserConfigLoader;
import org.apache.lens.server.user.UserConfigLoaderException;

public class UserConfigLoaderFactory {
    private static HiveConf conf;
    private static UserConfigLoader userConfigLoader;

    public static void init(HiveConf c) {
        conf = c;
        userConfigLoader = UserConfigLoaderFactory.initializeUserConfigLoader();
    }

    public static UserConfigLoader initializeUserConfigLoader() {
        String resolverType = conf.get("lens.server.user.resolver.type");
        if (resolverType == null || resolverType.length() == 0) {
            throw new UserConfigLoaderException("user resolver type not determined. value was not provided in conf");
        }
        for (RESOLVER_TYPE type : RESOLVER_TYPE.values()) {
            if (!type.name().equals(resolverType)) continue;
            return UserConfigLoaderFactory.getQueryUserResolver(type);
        }
        throw new UserConfigLoaderException("user resolver type not determined. provided value: " + resolverType);
    }

    public static UserConfigLoader getQueryUserResolver(RESOLVER_TYPE resolverType) {
        switch (resolverType) {
            case PROPERTYBASED: {
                return new PropertyBasedUserConfigLoader(conf);
            }
            case DATABASE: {
                return new DatabaseUserConfigLoader(conf);
            }
            case LDAP_BACKED_DATABASE: {
                return new LDAPBackedDatabaseUserConfigLoader(conf);
            }
            case CUSTOM: {
                return new CustomUserConfigLoader(conf);
            }
        }
        return new FixedUserConfigLoader(conf);
    }

    public static Map<String, String> getUserConfig(String loggedInUser) {
        return userConfigLoader.getUserConfig(loggedInUser);
    }

    public static enum RESOLVER_TYPE {
        FIXED,
        PROPERTYBASED,
        DATABASE,
        LDAP_BACKED_DATABASE,
        CUSTOM;

    }
}

