/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server.user;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.lens.server.user.UserConfigLoader;
import org.apache.lens.server.user.UserConfigLoaderException;

public class PropertyBasedUserConfigLoader
extends UserConfigLoader {
    private HashMap<String, Map<String, String>> userMap = new HashMap();

    public PropertyBasedUserConfigLoader(HiveConf conf) throws UserConfigLoaderException {
        super(conf);
        Properties properties = new Properties();
        String filename = this.hiveConf.get("lens.server.user.resolver.propertybased.filename", null);
        if (filename == null) {
            throw new UserConfigLoaderException("property file path not provided for property based resolver.Please set property lens.server.user.resolver.propertybased.filename");
        }
        try {
            properties.load(new InputStreamReader(new FileInputStream(new File(filename))));
        }
        catch (IOException e) {
            throw new UserConfigLoaderException("property file not found. Provided path was: " + filename);
        }
        for (Object o : properties.keySet()) {
            String key = (String)o;
            String[] userAndPropkey = key.split("\\.", 2);
            String user = userAndPropkey[0];
            String propKey = userAndPropkey[1];
            if (!this.userMap.containsKey(user)) {
                this.userMap.put(user, new HashMap());
            }
            this.userMap.get(user).put(propKey, properties.getProperty(key));
        }
    }

    @Override
    public Map<String, String> getUserConfig(String loggedInUser) {
        return this.userMap.get(loggedInUser) == null ? this.userMap.get("*") : this.userMap.get(loggedInUser);
    }
}

