/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server.user;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.lens.server.user.UserConfigLoader;
import org.apache.lens.server.user.UserConfigLoaderException;

public class CustomUserConfigLoader
extends UserConfigLoader {
    Class<? extends UserConfigLoader> customHandlerClass;
    UserConfigLoader customProvider;

    public CustomUserConfigLoader(HiveConf conf) {
        super(conf);
        this.customHandlerClass = this.hiveConf.getClass("lens.server.user.resolver.custom.class", UserConfigLoader.class);
        try {
            this.customProvider = this.customHandlerClass.getConstructor(HiveConf.class).newInstance(conf);
        }
        catch (InvocationTargetException e) {
            throw new UserConfigLoaderException(e);
        }
        catch (NoSuchMethodException e) {
            throw new UserConfigLoaderException(e);
        }
        catch (InstantiationException e) {
            throw new UserConfigLoaderException(e);
        }
        catch (IllegalAccessException e) {
            throw new UserConfigLoaderException(e);
        }
    }

    @Override
    public Map<String, String> getUserConfig(String loggedInUser) throws UserConfigLoaderException {
        return this.customProvider.getUserConfig(loggedInUser);
    }
}

